/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.disparity;

import boofcv.abst.disparity.StereoDisparitySparse;
import boofcv.alg.disparity.block.DisparitySparseSelect;
import boofcv.alg.disparity.block.score.DisparitySparseRectifiedScoreBM;
import boofcv.struct.image.ImageGray;

public class WrapDisparitySparseRectifiedBM<ArrayData, T extends ImageGray<T>>
implements StereoDisparitySparse<T> {
    DisparitySparseRectifiedScoreBM<ArrayData, T> computeScore;
    DisparitySparseSelect<ArrayData> select;
    double minDisparityFloat;

    public WrapDisparitySparseRectifiedBM(DisparitySparseRectifiedScoreBM<ArrayData, T> computeScore, DisparitySparseSelect<ArrayData> select) {
        this.computeScore = computeScore;
        this.select = select;
    }

    @Override
    public void setImages(T imageLeft, T imageRight) {
        this.computeScore.setImages(imageLeft, imageRight);
        this.minDisparityFloat = this.computeScore.getDisparityMin();
    }

    @Override
    public double getDisparity() {
        return this.minDisparityFloat + this.select.getDisparity();
    }

    @Override
    public boolean process(int x, int y) {
        return this.select.select(this.computeScore, x, y);
    }

    @Override
    public int getBorderX() {
        return this.computeScore.getRadiusX();
    }

    @Override
    public int getBorderY() {
        return this.computeScore.getRadiusY();
    }

    @Override
    public int getMinDisparity() {
        return this.computeScore.getDisparityMin();
    }

    @Override
    public int getMaxDisparity() {
        return this.computeScore.getDisparityMax();
    }

    @Override
    public Class<T> getInputType() {
        return this.computeScore.getInputType();
    }

    public DisparitySparseRectifiedScoreBM<ArrayData, T> getComputeScore() {
        return this.computeScore;
    }

    public DisparitySparseSelect<ArrayData> getSelect() {
        return this.select;
    }
}

