/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.io.points.impl.ObjLoadFromFiles;
import java.io.BufferedReader;
import java.io.IOException;
import org.ddogleg.struct.DogArray_I32;

public abstract class ObjFileReader {
    DogArray_I32 vertexIndexes = new DogArray_I32();
    int vertexCount = 0;
    int vertexTextureCount = 0;
    int vertexNormalCount = 0;

    public void parse(BufferedReader reader) throws IOException {
        String l;
        this.vertexCount = 0;
        this.vertexTextureCount = 0;
        this.vertexNormalCount = 0;
        StringBuilder builder = new StringBuilder();
        int actualLineCount = 0;
        while ((l = reader.readLine()) != null) {
            Object line;
            String chunk;
            ++actualLineCount;
            if (l.length() == 0 || l.charAt(0) == '#' || (chunk = l.trim()).isEmpty()) continue;
            if (chunk.endsWith("\\")) {
                if (builder.length() != 0) {
                    builder.append(' ');
                }
                builder.append(chunk);
                continue;
            }
            if (builder.length() == 0) {
                line = chunk;
            } else {
                line = builder.toString() + " " + chunk;
                builder.setLength(0);
            }
            String[] words = ((String)line).split("\\s+");
            try {
                switch (words[0]) {
                    case "v": {
                        double x = Double.parseDouble(words[1]);
                        double y = Double.parseDouble(words[2]);
                        double z = Double.parseDouble(words[3]);
                        if (words.length == 7) {
                            double r = Double.parseDouble(words[4]);
                            double g = Double.parseDouble(words[5]);
                            double b = Double.parseDouble(words[6]);
                            this.addVertexWithColor(x, y, z, r, g, b);
                        } else {
                            this.addVertex(x, y, z);
                        }
                        ++this.vertexCount;
                        break;
                    }
                    case "vn": {
                        double x = Double.parseDouble(words[1]);
                        double y = Double.parseDouble(words[2]);
                        double z = Double.parseDouble(words[3]);
                        this.addVertexNormal(x, y, z);
                        ++this.vertexNormalCount;
                        break;
                    }
                    case "vt": {
                        double x = Double.parseDouble(words[1]);
                        double y = Double.parseDouble(words[2]);
                        this.addVertexTexture(x, y);
                        ++this.vertexTextureCount;
                        break;
                    }
                    case "p": {
                        this.addPoint(this.ensureIndex(Integer.parseInt(words[1])));
                        break;
                    }
                    case "l": {
                        this.readPoints(words);
                        this.addLine(this.vertexIndexes);
                        break;
                    }
                    case "f": {
                        this.readFaceIndexes(words);
                        this.addFace(this.vertexIndexes, words.length - 1);
                        break;
                    }
                    case "mtllib": {
                        this.addLibrary(words[1]);
                        break;
                    }
                    case "usemtl": {
                        this.addMaterial(words[1]);
                        break;
                    }
                    default: {
                        this.handleError(actualLineCount + " Unknown object type. '" + words[0] + "'");
                        break;
                    }
                }
            }
            catch (ObjLoadFromFiles.MultipleMaterials e) {
                return;
            }
            catch (Exception e) {
                this.handleError(actualLineCount + " Bad object description " + words[0] + " '" + e.getMessage() + "'");
            }
        }
    }

    int ensureIndex(int found) {
        if (found > 0) {
            return found - 1;
        }
        return this.vertexCount + found;
    }

    private void readPoints(String[] words) {
        this.vertexIndexes.reset();
        for (int i = 1; i < words.length; ++i) {
            this.vertexIndexes.add(this.ensureIndex(Integer.parseInt(words[i])));
        }
    }

    private void readFaceIndexes(String[] words) {
        this.vertexIndexes.reset();
        for (int i = 1; i < words.length; ++i) {
            String word = words[i];
            int idx0 = 0;
            int idx1 = word.indexOf(47);
            while (idx1 != -1) {
                this.vertexIndexes.add(this.ensureIndex(Integer.parseInt(word.substring(idx0, idx1))));
                idx0 = idx1 + 1;
                idx1 = word.indexOf(47, idx0);
            }
            this.vertexIndexes.add(this.ensureIndex(Integer.parseInt(word.substring(idx0))));
        }
    }

    protected abstract void addLibrary(String var1);

    protected abstract void addMaterial(String var1);

    protected abstract void addVertex(double var1, double var3, double var5);

    protected abstract void addVertexWithColor(double var1, double var3, double var5, double var7, double var9, double var11);

    protected abstract void addVertexNormal(double var1, double var3, double var5);

    protected abstract void addVertexTexture(double var1, double var3);

    protected abstract void addPoint(int var1);

    protected abstract void addLine(DogArray_I32 var1);

    protected abstract void addFace(DogArray_I32 var1, int var2);

    protected void handleError(String message) {
        System.err.println(message);
    }
}

