/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.alg.cloud.PointCloudReader;
import boofcv.alg.cloud.PointCloudWriter;
import boofcv.io.points.impl.ObjFileReader;
import boofcv.io.points.impl.ObjFileWriter;
import boofcv.struct.mesh.VertexMesh;
import georegression.struct.point.Point3D_F64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;
import org.ddogleg.struct.DogArray_I32;

public class ObjFileCodec {
    public static void save(PointCloudReader cloud, Writer writer) throws IOException {
        ObjFileWriter obj = new ObjFileWriter(writer);
        obj.addComment("Created by BoofCV");
        boolean hasColor = cloud.colors();
        Point3D_F64 point = new Point3D_F64();
        int N = cloud.size();
        for (int i = 0; i < N; ++i) {
            cloud.get(i, point);
            if (hasColor) {
                ObjFileCodec.addRgbVertex(obj, point, cloud.getRGB(i));
            } else {
                obj.addVertex(point.x, point.y, point.z);
            }
            obj.addPoint(-1);
        }
    }

    public static void saveMtl(String textureFile, Writer writer) throws IOException {
        String text = "newmtl %s\nKa 1.0 1.0 1.0\nKd 1.0 1.0 1.0\nKs 0.0 0.0 0.0\nd 1.0\nNs 0.0\nillum 0\nmap_Kd %s";
        String baseName = FilenameUtils.getBaseName((String)textureFile);
        writer.write(String.format(text, baseName, textureFile));
    }

    public static void save(VertexMesh mesh, Writer writer) throws IOException {
        Point3D_F64 p;
        int i;
        ObjFileWriter obj = new ObjFileWriter(writer);
        obj.addComment("Created by BoofCV");
        if (!mesh.textureName.isEmpty()) {
            String baseName = FilenameUtils.getBaseName((String)mesh.textureName);
            obj.addLibrary(baseName + ".mtl");
            obj.addMaterial(baseName);
        }
        boolean hasVertexColors = mesh.rgb.size > 0;
        int N = mesh.vertexes.size();
        for (i = 0; i < N; ++i) {
            p = mesh.vertexes.getTemp(i);
            if (hasVertexColors) {
                ObjFileCodec.addRgbVertex(obj, p, mesh.rgb.get(i));
                continue;
            }
            obj.addVertex(p.x, p.y, p.z);
        }
        for (i = 0; i < mesh.normals.size(); ++i) {
            p = mesh.normals.getTemp(i);
            obj.addVertexNormal(p.x, p.y, p.z);
        }
        for (i = 0; i < mesh.texture.size(); ++i) {
            p = mesh.texture.getTemp(i);
            obj.addTextureVertex(p.x, p.y);
        }
        int count = 0;
        if (mesh.vertexes.size() > 0) {
            ++count;
        }
        if (mesh.normals.size() > 0) {
            ++count;
        }
        if (mesh.texture.size() > 0) {
            ++count;
        }
        DogArray_I32 indexes = new DogArray_I32();
        for (int i2 = 1; i2 < mesh.faceOffsets.size; ++i2) {
            int idx0 = mesh.faceOffsets.get(i2 - 1);
            int idx1 = mesh.faceOffsets.get(i2);
            indexes.reset();
            indexes.addAll(mesh.faceVertexes.data, idx0, idx1);
            obj.addFace(indexes, count);
        }
    }

    private static void addRgbVertex(ObjFileWriter obj, Point3D_F64 p, int rgb) throws IOException {
        double red = (double)(rgb >> 16 & 0xFF) / 255.0;
        double green = (double)(rgb >> 8 & 0xFF) / 255.0;
        double blue = (double)(rgb & 0xFF) / 255.0;
        obj.addVertex(p.x, p.y, p.z, red, green, blue);
    }

    public static void load(InputStream input, final PointCloudWriter output) throws IOException {
        ObjFileReader obj = new ObjFileReader(){

            @Override
            protected void addLibrary(String name) {
            }

            @Override
            protected void addMaterial(String name) {
            }

            @Override
            protected void addVertex(double x, double y, double z) {
                output.startPoint();
                output.location(x, y, z);
                output.stopPoint();
            }

            @Override
            protected void addVertexWithColor(double x, double y, double z, double red, double green, double blue) {
                output.startPoint();
                output.location(x, y, z);
                output.color(ObjFileCodec.convertToInt(red, green, blue));
                output.stopPoint();
            }

            @Override
            protected void addVertexNormal(double x, double y, double z) {
            }

            @Override
            protected void addVertexTexture(double x, double y) {
            }

            @Override
            protected void addPoint(int vertex) {
            }

            @Override
            protected void addLine(DogArray_I32 vertexes) {
            }

            @Override
            protected void addFace(DogArray_I32 indexes, int vertexCount) {
            }
        };
        obj.parse(new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)));
    }

    public static void load(InputStream input, final VertexMesh output) throws IOException {
        output.reset();
        ObjFileReader obj = new ObjFileReader(){

            @Override
            protected void addLibrary(String name) {
            }

            @Override
            protected void addMaterial(String name) {
            }

            @Override
            protected void addVertex(double x, double y, double z) {
                output.vertexes.append(x, y, z);
            }

            @Override
            protected void addVertexWithColor(double x, double y, double z, double red, double green, double blue) {
                output.vertexes.append(x, y, z);
                output.rgb.add(ObjFileCodec.convertToInt(red, green, blue));
            }

            @Override
            protected void addVertexNormal(double x, double y, double z) {
                output.normals.append((float)x, (float)y, (float)z);
            }

            @Override
            protected void addVertexTexture(double x, double y) {
                output.texture.append((float)x, (float)y);
            }

            @Override
            protected void addPoint(int vertex) {
            }

            @Override
            protected void addLine(DogArray_I32 vertexes) {
            }

            @Override
            protected void addFace(DogArray_I32 indexes, int vertexCount) {
                ObjFileCodec.addFactToMesh(indexes, vertexCount, output);
            }
        };
        obj.parse(new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)));
    }

    static void addFactToMesh(DogArray_I32 indexes, int vertexCount, VertexMesh output) {
        boolean hasTexture = output.texture.size() > 0;
        boolean hasNormals = output.normals.size() > 0;
        int typeCount = indexes.size / vertexCount;
        for (int idxVert = 0; idxVert < vertexCount; ++idxVert) {
            int index = idxVert * typeCount;
            output.faceVertexes.add(indexes.get(index++));
            if (hasTexture) {
                output.faceVertexTextures.add(indexes.get(index++));
            }
            if (!hasNormals) continue;
            output.faceVertexNormals.add(indexes.get(index));
        }
        output.faceOffsets.add(output.faceVertexes.size);
    }

    static int convertToInt(double red, double green, double blue) {
        return (int)(255.0 * red + 0.5) << 16 | (int)(255.0 * green + 0.5) << 8 | (int)(255.0 * blue + 0.5);
    }
}

