/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;
import java.io.Reader;
import org.jetbrains.annotations.Nullable;

public interface MediaManager {
    @Nullable
    public Reader openFile(String var1);

    default public Reader openFileNotNull(String fileName) {
        Reader r = this.openFile(fileName);
        if (r == null) {
            throw new RuntimeException("Failed to open file=" + fileName);
        }
        return r;
    }

    @Nullable
    public BufferedImage openImage(String var1);

    default public BufferedImage openImageNotNull(String fileName) {
        BufferedImage image = this.openImage(fileName);
        if (image == null) {
            throw new RuntimeException("Failed to open image=" + fileName);
        }
        return image;
    }

    @Nullable
    public <T extends ImageBase<T>> SimpleImageSequence<T> openVideo(String var1, ImageType<T> var2);

    default public <T extends ImageBase<T>> SimpleImageSequence<T> openVideoNotNull(String fileName, ImageType<T> imageInfo) {
        SimpleImageSequence<T> video = this.openVideo(fileName, imageInfo);
        if (video == null) {
            throw new RuntimeException("Failed to open video=" + fileName);
        }
        return video;
    }

    @Nullable
    public <T extends ImageBase<T>> SimpleImageSequence<T> openCamera(String var1, int var2, int var3, ImageType<T> var4);

    default public <T extends ImageBase<T>> SimpleImageSequence<T> openCameraNotNull(String fileName, int width, int height, ImageType<T> imageType) {
        SimpleImageSequence<T> camera = this.openCamera(fileName, width, height, imageType);
        if (camera == null) {
            throw new RuntimeException("Failed to open camera=" + fileName);
        }
        return camera;
    }
}

