/*
 * Decompiled with CFR 0.152.
 */
package boofcv.visualize;

import boofcv.visualize.PeriodicColorizer;

public abstract class SingleAxisRgb
extends PeriodicColorizer {
    private static final int HV = 255;
    private static final int LV = 0;

    final int color(double val) {
        int b;
        int g;
        int r;
        double f = this.triangleWave(val);
        double a = (1.0 - f) / 0.25;
        int X2 = (int)Math.floor(a);
        int Y2 = (int)Math.floor(255.0 * (a - (double)X2));
        switch (X2) {
            case 0: {
                r = 255;
                g = Y2;
                b = 0;
                break;
            }
            case 1: {
                r = 255 - Y2;
                g = 255;
                b = 0;
                break;
            }
            case 2: {
                r = 0;
                g = 255;
                b = Y2;
                break;
            }
            case 3: {
                r = 0;
                g = 255 - Y2;
                b = 255;
                break;
            }
            case 4: {
                r = 0;
                g = 0;
                b = 255;
                break;
            }
            default: {
                throw new RuntimeException("BUG! X=" + X2 + "  f=" + f);
            }
        }
        return r << 16 | g << 8 | b;
    }

    public static class Z
    extends SingleAxisRgb {
        @Override
        public int color(int index, double x, double y, double z) {
            return this.color(z);
        }
    }

    public static class Y
    extends SingleAxisRgb {
        @Override
        public int color(int index, double x, double y, double z) {
            return this.color(y);
        }
    }

    public static class X
    extends SingleAxisRgb {
        @Override
        public int color(int index, double x, double y, double z) {
            return this.color(x);
        }
    }
}

