/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.serialize;

import boofcv.struct.Configuration;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class SerializeFieldsYamlBase {
    public HandleError errorHandler = (type, description, e) -> {
        if (e != null) {
            throw e;
        }
        throw new RuntimeException(description);
    };
    public AllowClasses allowClasses = SerializeFieldsYamlBase::allowedDeserialize;

    /*
     * Unable to fully structure code
     */
    public Map<String, Object> serialize(Object config, @Nullable Object canonical) {
        state = new HashMap<String, Object>();
        type = config.getClass();
        fields = type.getFields();
        active = new ArrayList<E>();
        if (config instanceof Configuration) {
            active = ((Configuration)config).serializeActiveFields();
        }
        block8: for (Field f : fields) {
            if (!active.isEmpty() && !active.contains(f.getName())) continue;
            try {
                block18: {
                    if (f.getType().isEnum() || f.getType().isPrimitive() || f.getType().getName().equals("java.lang.String")) {
                        try {
                            targetValue = f.get(config);
                            v0 = canonicalValue = canonical == null ? null : f.get(canonical);
                            if (canonicalValue == null && targetValue == null || targetValue != null && targetValue.equals(canonicalValue)) continue;
                            state.put(f.getName(), f.getType().isEnum() != false ? ((Enum)targetValue).name() : targetValue);
                        }
                        catch (RuntimeException e) {
                            this.errorHandler.handle(ErrorType.MISC, "class=" + type.getSimpleName() + " field=" + f.getName(), e);
                        }
                        continue;
                    }
                    if (!FastAccess.class.isAssignableFrom(f.getType())) break block18;
                    list = (FastAccess)f.get(config);
                    if (canonical == null) ** GOTO lbl30
                    listCanon = (FastAccess)f.get(canonical);
                    if (list.size() != listCanon.size()) ** GOTO lbl30
                    if (list.isEmpty()) continue;
                    for (i = 0; i < list.size(); ++i) {
                        if (list.get(i).equals(listCanon.get(i))) {
                            continue;
                        }
lbl30:
                        // 4 sources

                        basic = (itemType = list.type).isEnum() != false || itemType.isPrimitive() != false || itemType.getName().equals("java.lang.String") != false;
                        canonicalOfData = null;
                        if (canonical != null && !basic) {
                            try {
                                canonicalOfData = list.type.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (Exception e) {
                                this.errorHandler.handle(ErrorType.MISC, "Failed to create instance of '" + list.type.getSimpleName() + "'", null);
                            }
                        }
                        serializedList = new ArrayList<Object>();
                        for (i = 0; i < list.size(); ++i) {
                            value = list.get(i);
                            if (basic) {
                                serializedList.add(itemType.isEnum() != false ? ((Enum)value).name() : value);
                                continue;
                            }
                            serializedList.add(this.serialize(value, canonicalOfData));
                        }
                        state.put(f.getName(), serializedList);
                        continue block8;
                    }
                    continue;
                }
                if (List.class.isAssignableFrom(f.getType())) {
                    this.errorHandler.handle(ErrorType.UNSUPPORTED, "Can't serialize lists. Use FastArray instead since it specifies the item type. name=" + f.getName(), null);
                    continue;
                }
                if (f.getType().isArray()) {
                    state.put(f.getName(), f.get(config));
                    continue;
                }
                try {
                    type.getMethod("setTo", new Class[]{type});
                }
                catch (NoSuchMethodException e) {
                    this.errorHandler.handle(ErrorType.UNSUPPORTED, "Referenced object which is not enum, primitive, or a valid class. class='" + type.getSimpleName() + "' field_name='" + f.getName() + "'", null);
                    continue;
                }
                v1 = result = canonical != null ? this.serialize(f.get(config), f.get(canonical)) : this.serialize(f.get(config), null);
                if (result.isEmpty()) continue;
                state.put(f.getName(), result);
            }
            catch (IllegalAccessException e) {
                this.errorHandler.handle(ErrorType.REFLECTION, String.format("IllegalAccess. class='%s' field='%s'", new Object[]{type.getSimpleName(), f.getName()}), new RuntimeException(e));
            }
        }
        return state;
    }

    protected void deserialize(Object parent, Map<String, Object> state) {
        Class<?> type = parent.getClass();
        for (String key : state.keySet()) {
            try {
                Field f = type.getField(key);
                Class<?> ftype = f.getType();
                if (ftype.isEnum()) {
                    this.checkBeforeDeserialize(ftype);
                    Object value = state.get(key);
                    if (value.getClass().isEnum()) {
                        f.set(parent, value);
                        continue;
                    }
                    f.set(parent, Enum.valueOf(ftype, (String)value));
                    continue;
                }
                if (ftype.isPrimitive()) {
                    this.deserializePrimitive(parent, state, key, f, ftype);
                    continue;
                }
                if (ftype.isArray()) {
                    this.deserializePrimitiveArray(parent, state, key, f, ftype);
                    continue;
                }
                if (ftype.getName().equals("java.lang.String")) {
                    f.set(parent, state.get(key));
                    continue;
                }
                if (FastAccess.class.isAssignableFrom(ftype)) {
                    this.deserializeFastAccess(parent, state, key, f);
                    continue;
                }
                this.checkBeforeDeserialize(ftype);
                Object child = ftype.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.deserialize(child, (Map)state.get(key));
                Class<?> c = child.getClass();
                c.getMethod("setTo", c).invoke(f.get(parent), child);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                this.errorHandler.handle(ErrorType.REFLECTION, String.format("%s class='%s' key='%s'", e.getClass().getSimpleName(), type.getSimpleName(), key), null);
            }
        }
    }

    private void deserializePrimitive(Object parent, Map<String, Object> state, String key, Field f, Class ftype) throws IllegalAccessException {
        Object value = state.get(key);
        if (ftype == Boolean.TYPE) {
            f.set(parent, value);
        } else if (ftype == Byte.TYPE) {
            f.set(parent, ((Number)value).byteValue());
        } else if (ftype == Character.TYPE) {
            f.set(parent, value);
        } else if (ftype == Short.TYPE) {
            f.set(parent, ((Number)value).shortValue());
        } else if (ftype == Integer.TYPE) {
            f.set(parent, ((Number)value).intValue());
        } else if (ftype == Long.TYPE) {
            f.set(parent, ((Number)value).longValue());
        } else if (ftype == Float.TYPE) {
            f.set(parent, Float.valueOf(((Number)value).floatValue()));
        } else if (ftype == Double.TYPE) {
            f.set(parent, ((Number)value).doubleValue());
        } else {
            this.errorHandler.handle(ErrorType.UNEXPECTED_TYPE, "Unknown primitive " + ftype, null);
        }
    }

    private void deserializePrimitiveArray(Object parent, Map<String, Object> state, String key, Field f, Class ftype) throws IllegalAccessException {
        Object value = state.get(key);
        if (ftype == boolean[].class) {
            List list = (List)value;
            boolean[] array = new boolean[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Boolean)list.get(i);
            }
            f.set(parent, array);
        } else if (ftype == byte[].class) {
            f.set(parent, ((byte[])value).clone());
        } else if (ftype == char[].class) {
            f.set(parent, ((char[])value).clone());
        } else if (ftype == short[].class) {
            List list = (List)value;
            short[] array = new short[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Number)list.get(i)).shortValue();
            }
            f.set(parent, array);
        } else if (ftype == int[].class) {
            List list = (List)value;
            int[] array = new int[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Integer)list.get(i);
            }
            f.set(parent, array);
        } else if (ftype == long[].class) {
            List list = (List)value;
            long[] array = new long[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Number)list.get(i)).longValue();
            }
            f.set(parent, array);
        } else if (ftype == float[].class) {
            List list = (List)value;
            float[] array = new float[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Number)list.get(i)).floatValue();
            }
            f.set(parent, array);
        } else if (ftype == double[].class) {
            List list = (List)value;
            double[] array = new double[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Number)list.get(i)).doubleValue();
            }
            f.set(parent, array);
        } else {
            this.errorHandler.handle(ErrorType.UNEXPECTED_TYPE, "Unknown primitive array " + ftype, null);
        }
    }

    private void deserializeFastAccess(Object parent, Map<String, Object> state, String key, Field f) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        List listOfStates = (List)state.get(key);
        if (listOfStates.isEmpty()) {
            return;
        }
        if (FastArray.class.isAssignableFrom(f.get(parent).getClass())) {
            FastArray plist = (FastArray)f.get(parent);
            Class itemType = plist.type;
            this.checkBeforeDeserialize(itemType);
            boolean basic = itemType.isEnum() || itemType.isPrimitive() || itemType.getName().equals("java.lang.String");
            plist.reset();
            for (int i = 0; i < listOfStates.size(); ++i) {
                Object value = listOfStates.get(i);
                if (basic) {
                    if (itemType.isEnum()) {
                        plist.add(Enum.valueOf(itemType, (String)value));
                        continue;
                    }
                    plist.add(value);
                    continue;
                }
                Object dst = itemType.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.deserialize(dst, (Map)value);
                plist.add(dst);
            }
        } else {
            DogArray plist = (DogArray)f.get(parent);
            plist.reset().resize(listOfStates.size());
            for (int i = 0; i < listOfStates.size(); ++i) {
                Object value = listOfStates.get(i);
                Object dst = plist.get(i);
                this.deserialize(dst, (Map)value);
            }
        }
    }

    protected void checkBeforeDeserialize(Class type) throws IllegalAccessException {
        this.checkBeforeDeserialize(type.getName());
    }

    protected void checkBeforeDeserialize(String name) throws IllegalAccessException {
        if (!this.allowClasses.allow(name)) {
            throw new IllegalAccessException("Attempted to deserialize a class that's not allowed. " + name);
        }
    }

    public static boolean allowedDeserialize(String name) {
        if (name.startsWith("boofcv")) {
            return true;
        }
        if (name.startsWith("org.ejml")) {
            return true;
        }
        if (name.startsWith("org.ddogleg")) {
            return true;
        }
        if (name.startsWith("org.georegression")) {
            return true;
        }
        return name.startsWith("java.lang.String");
    }

    public static Yaml createYmlObject() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(options);
    }

    @FunctionalInterface
    public static interface HandleError {
        public void handle(ErrorType var1, String var2, @Nullable RuntimeException var3);
    }

    @FunctionalInterface
    public static interface AllowClasses {
        public boolean allow(String var1);
    }

    public static enum ErrorType {
        REFLECTION,
        MISC,
        UNSUPPORTED,
        UNKNOWN_FIELD,
        UNEXPECTED_TYPE;

    }
}

