/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.io.points.StlDataStructure;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class StlFileReader {
    public AddVertex opVertexAdd = (x, y, z, out) -> {
        out.facetVertsIdx.add(out.vertexes.size());
        out.vertexes.append(x, y, z);
    };

    public void readAscii(BufferedReader input, StlDataStructure out) throws IOException {
        String line;
        out.reset();
        int lineCount = 0;
        while ((line = input.readLine()) != null) {
            if ((line = line.strip()).isEmpty()) continue;
            String[] words = line.split("\\s+");
            switch (words[0]) {
                case "solid": {
                    if (words.length != 2) {
                        throw new IOException("Line " + lineCount + " : Expected 2 words for a solid");
                    }
                    out.name = words[1];
                    break;
                }
                case "facet": {
                    if (words.length != 5) {
                        throw new IOException("Line " + lineCount + " : Expected 5 words for a facet");
                    }
                    double nx = Double.parseDouble(words[2]);
                    double ny = Double.parseDouble(words[3]);
                    double nz = Double.parseDouble(words[4]);
                    out.normals.append(nx, ny, nz);
                    break;
                }
                case "vertex": {
                    if (words.length != 4) {
                        throw new IOException("Line " + lineCount + " : Expected 4 words for a vertex");
                    }
                    double vx = Double.parseDouble(words[1]);
                    double vy = Double.parseDouble(words[2]);
                    double vz = Double.parseDouble(words[3]);
                    this.opVertexAdd.addVertex(vx, vy, vz, out);
                    break;
                }
            }
        }
    }

    public void readBinary(InputStream input, StlDataStructure out) throws IOException {
        out.reset();
        byte[] line = new byte[80];
        int amountRead = input.read(line, 0, 80);
        if (amountRead != 80) {
            throw new IOException("Couldn't read in entire header. amount=" + amountRead);
        }
        int stringLength = line.length;
        for (int i = 0; i < line.length; ++i) {
            if (line[i] != 0) continue;
            stringLength = i;
            break;
        }
        out.name = new String(line, 0, stringLength, StandardCharsets.UTF_8);
        if (4 != input.read(line, 0, 4)) {
            throw new IOException("Failed to read number of facets");
        }
        ByteBuffer bb = ByteBuffer.wrap(line);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int numFacets = bb.getInt(0);
        int facetBytes = 50;
        out.facetVertsIdx.resize(numFacets * 3).reset();
        out.vertexes.reserve(numFacets * 3);
        out.normals.reserve(numFacets);
        for (int i = 0; i < numFacets; ++i) {
            int readBytes = input.read(line, 0, facetBytes);
            if (facetBytes != readBytes) {
                throw new IOException("Failed to read data for facet " + i + ". bytes=" + readBytes);
            }
            out.normals.append((double)bb.getFloat(0), (double)bb.getFloat(4), (double)bb.getFloat(8));
            this.opVertexAdd.addVertex(bb.getFloat(12), bb.getFloat(16), bb.getFloat(20), out);
            this.opVertexAdd.addVertex(bb.getFloat(24), bb.getFloat(28), bb.getFloat(32), out);
            this.opVertexAdd.addVertex(bb.getFloat(36), bb.getFloat(40), bb.getFloat(44), out);
        }
    }

    @FunctionalInterface
    static interface AddVertex {
        public void addVertex(double var1, double var3, double var5, StlDataStructure var7);
    }
}

