/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points;

import boofcv.struct.mesh.MeshPolygonAccess;
import boofcv.struct.mesh.VertexMesh;
import boofcv.struct.packed.PackedBigArrayPoint3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class StlDataStructure {
    public final PackedBigArrayPoint3D_F64 vertexes = new PackedBigArrayPoint3D_F64(10);
    public final PackedBigArrayPoint3D_F64 normals = new PackedBigArrayPoint3D_F64(10);
    public DogArray_I32 facetVertsIdx = new DogArray_I32(2);
    public String name = "";

    public void reset() {
        this.vertexes.reset();
        this.normals.reset();
        this.facetVertsIdx.reset();
        this.name = "";
    }

    public StlDataStructure setTo(StlDataStructure src) {
        this.vertexes.setTo(src.vertexes);
        this.normals.setTo(src.normals);
        this.facetVertsIdx.setTo(src.facetVertsIdx);
        this.name = src.name;
        return this;
    }

    public void addFacet(Point3D_F64 v1, Point3D_F64 v2, Point3D_F64 v3, Vector3D_F64 normal) {
        for (int i = 0; i < 3; ++i) {
            this.facetVertsIdx.add(this.vertexes.size() + i);
        }
        this.vertexes.append(v1);
        this.vertexes.append(v2);
        this.vertexes.append(v3);
        this.normals.append((GeoTuple3D_F64)normal);
    }

    public void addFacet(Point3D_F64 v1, Point3D_F64 v2, Point3D_F64 v3) {
        for (int i = 0; i < 3; ++i) {
            this.facetVertsIdx.add(this.vertexes.size() + i);
        }
        this.vertexes.append(v1);
        this.vertexes.append(v2);
        this.vertexes.append(v3);
        this.addNormal(v1, v2, v3);
    }

    public void addFacet(int vertIdx1, int vertIdx2, int vertIdx3, Vector3D_F64 normal) {
        this.facetVertsIdx.add(vertIdx1);
        this.facetVertsIdx.add(vertIdx2);
        this.facetVertsIdx.add(vertIdx3);
        this.normals.append((GeoTuple3D_F64)normal);
    }

    private void addNormal(Point3D_F64 v1, Point3D_F64 v2, Point3D_F64 v3) {
        double ax = v2.x - v1.x;
        double ay = v2.y - v1.y;
        double az = v2.z - v1.z;
        double bx = v3.x - v1.x;
        double by = v3.y - v1.y;
        double bz = v3.z - v1.z;
        Point3D_F64 t = this.vertexes.temp;
        GeometryMath_F64.cross((double)ax, (double)ay, (double)az, (double)bx, (double)by, (double)bz, (GeoTuple3D_F64)t);
        double n = t.norm();
        t.divideIP(n);
        this.normals.append(t.x, t.y, t.z);
    }

    public int facetCount() {
        return this.normals.size();
    }

    public int size() {
        return this.normals.size();
    }

    public void getFacet(int which, Vector3D_F64 outNormal, DogArray<Point3D_F64> outVertexes) {
        if (which < 0 || which >= this.normals.size()) {
            throw new IllegalArgumentException("Index of facet is out of bounds");
        }
        this.normals.getCopy(which, (GeoTuple3D_F64)outNormal);
        outVertexes.resize(3);
        int idx0 = which * 3;
        for (int i = 0; i < 3; ++i) {
            this.vertexes.getCopy(this.facetVertsIdx.get(idx0 + i), (Point3D_F64)outVertexes.get(i));
        }
    }

    public VertexMesh toMesh(@Nullable VertexMesh out) {
        if (out == null) {
            out = new VertexMesh();
        }
        out.vertexes.setTo(this.vertexes);
        out.indexes.setTo(this.facetVertsIdx);
        out.offsets.resize(this.facetCount() + 1);
        out.offsets.set(0, 0);
        for (int i = 1; i < out.offsets.size; ++i) {
            out.offsets.set(i, i * 3);
        }
        return out;
    }

    public MeshPolygonAccess toAccess() {
        return new MeshPolygonAccess(){
            Vector3D_F64 dummy = new Vector3D_F64();

            public int size() {
                return StlDataStructure.this.facetCount();
            }

            public void getPolygon(int which, DogArray<Point3D_F64> vertexes) {
                StlDataStructure.this.getFacet(which, this.dummy, vertexes);
            }
        };
    }
}

