/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.concurrency.BoofConcurrency;
import boofcv.io.image.impl.ImplConvertRaster;
import boofcv.io.image.impl.ImplConvertRaster_MT;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ConvertRaster {
    public static void bufferedToGray(DataBufferUShort buffer, WritableRaster src, GrayI16 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToGray(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToGray(buffer, src, dst);
        }
    }

    public static void bufferedToGray(BufferedImage src, GrayI16 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToGray(src, dst);
        } else {
            ImplConvertRaster.bufferedToGray(src, dst);
        }
    }

    public static void bufferedToGray(DataBufferInt buffer, WritableRaster src, GrayF32 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToGray(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToGray(buffer, src, dst);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void bufferedToGray(DataBufferByte buffer, WritableRaster src, GrayU8 dst) {
        byte[] srcData = buffer.getData();
        int numBands = src.getNumBands();
        int size = dst.getWidth() * dst.getHeight();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        int srcStrideDiff = srcStride - src.getNumDataElements() * dst.width;
        if (BoofConcurrency.USE_CONCURRENT) {
            if (numBands == 3) {
                ImplConvertRaster_MT.from_3BU8_to_U8(srcData, srcStride, srcOffset, dst);
                return;
            } else if (numBands == 1) {
                ImplConvertRaster_MT.from_1BU8_to_U8(srcData, size, srcStride, srcOffset, srcStrideDiff, dst);
                return;
            } else {
                if (numBands != 4) throw new RuntimeException("Unexpected number of bands found. Bands = " + numBands);
                ImplConvertRaster_MT.from_4BU8_to_U8(srcData, srcStride, srcOffset, dst);
            }
            return;
        } else if (numBands == 3) {
            ImplConvertRaster.from_3BU8_to_U8(srcData, srcStride, srcOffset, dst);
            return;
        } else if (numBands == 1) {
            ImplConvertRaster.from_1BU8_to_U8(srcData, size, srcStride, srcOffset, srcStrideDiff, dst);
            return;
        } else {
            if (numBands != 4) throw new RuntimeException("Unexpected number of bands found. Bands = " + numBands);
            ImplConvertRaster.from_4BU8_to_U8(srcData, srcStride, srcOffset, dst);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void bufferedToGray(DataBufferByte buffer, WritableRaster src, GrayF32 dst) {
        byte[] srcData = buffer.getData();
        int numBands = src.getNumBands();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        if (BoofConcurrency.USE_CONCURRENT) {
            if (numBands == 3) {
                ImplConvertRaster_MT.from_3BU8_to_F32(srcData, srcStride, srcOffset, dst);
                return;
            } else if (numBands == 1) {
                ImplConvertRaster_MT.from_1BU8_to_F32(srcData, srcStride, srcOffset, dst);
                return;
            } else {
                if (numBands != 4) throw new RuntimeException("Write more code here.");
                ImplConvertRaster_MT.from_4BU8_to_F32(srcData, srcStride, srcOffset, dst);
            }
            return;
        } else if (numBands == 3) {
            ImplConvertRaster.from_3BU8_to_F32(srcData, srcStride, srcOffset, dst);
            return;
        } else if (numBands == 1) {
            ImplConvertRaster.from_1BU8_to_F32(srcData, srcStride, srcOffset, dst);
            return;
        } else {
            if (numBands != 4) throw new RuntimeException("Write more code here.");
            ImplConvertRaster.from_4BU8_to_F32(srcData, srcStride, srcOffset, dst);
        }
    }

    public static int stride(WritableRaster raster) {
        while (raster.getWritableParent() != null) {
            raster = raster.getWritableParent();
        }
        return raster.getWidth() * raster.getNumDataElements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void bufferedToPlanar_U8(DataBufferByte buffer, WritableRaster src, Planar<GrayU8> dst) {
        byte[] srcData = buffer.getData();
        int numBands = src.getNumBands();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        if (BoofConcurrency.USE_CONCURRENT) {
            if (numBands == 3) {
                ImplConvertRaster_MT.from_3BU8_to_PLU8(srcData, srcStride, srcOffset, dst);
                return;
            } else if (numBands == 1) {
                ImplConvertRaster_MT.from_1BU8_to_PLU8(srcData, srcStride, srcOffset, dst);
                return;
            } else {
                if (numBands != 4) throw new RuntimeException("Write more code here.");
                ImplConvertRaster_MT.from_4BU8_to_PLU8(srcData, srcStride, srcOffset, dst);
            }
            return;
        } else if (numBands == 3) {
            ImplConvertRaster.from_3BU8_to_PLU8(srcData, srcStride, srcOffset, dst);
            return;
        } else if (numBands == 1) {
            ImplConvertRaster.from_1BU8_to_PLU8(srcData, srcStride, srcOffset, dst);
            return;
        } else {
            if (numBands != 4) throw new RuntimeException("Write more code here.");
            ImplConvertRaster.from_4BU8_to_PLU8(srcData, srcStride, srcOffset, dst);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void bufferedToPlanar_F32(DataBufferByte buffer, WritableRaster src, Planar<GrayF32> dst) {
        byte[] srcData = buffer.getData();
        int numBands = src.getNumBands();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        if (BoofConcurrency.USE_CONCURRENT) {
            if (numBands == 3) {
                ImplConvertRaster_MT.from_3BU8_to_PLF32(srcData, srcStride, srcOffset, dst);
                return;
            } else if (numBands == 1) {
                ImplConvertRaster_MT.from_1BU8_to_PLF32(srcData, srcStride, srcOffset, dst);
                return;
            } else {
                if (numBands != 4) throw new RuntimeException("Write more code here.");
                ImplConvertRaster_MT.from_4BU8_to_PLF32(srcData, srcStride, srcOffset, dst);
            }
            return;
        } else if (numBands == 3) {
            ImplConvertRaster.from_3BU8_to_PLF32(srcData, srcStride, srcOffset, dst);
            return;
        } else if (numBands == 1) {
            ImplConvertRaster.from_1BU8_to_PLF32(srcData, srcStride, srcOffset, dst);
            return;
        } else {
            if (numBands != 4) throw new RuntimeException("Write more code here.");
            ImplConvertRaster.from_4BU8_to_PLF32(srcData, srcStride, srcOffset, dst);
        }
    }

    public static void planarToBuffered_F32(Planar<GrayF32> src, DataBuffer buffer, BufferedImage dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            if (buffer.getDataType() == 0 && ConvertRaster.isKnownByteFormat(dst)) {
                ImplConvertRaster_MT.planarToBuffered_F32(src, (DataBufferByte)buffer, dst.getRaster());
            } else if (buffer.getDataType() == 3) {
                ImplConvertRaster_MT.planarToBuffered_F32(src, (DataBufferInt)buffer, dst.getRaster());
            } else {
                ImplConvertRaster_MT.planarToBuffered_F32(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        } else {
            if (buffer.getDataType() == 0 && ConvertRaster.isKnownByteFormat(dst)) {
                ImplConvertRaster.planarToBuffered_F32(src, (DataBufferByte)buffer, dst.getRaster());
            } else if (buffer.getDataType() == 3) {
                ImplConvertRaster.planarToBuffered_F32(src, (DataBufferInt)buffer, dst.getRaster());
            } else {
                ImplConvertRaster.planarToBuffered_F32(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
    }

    public static void interleavedToBuffered(InterleavedU8 src, DataBuffer buffer, BufferedImage dst, boolean orderRgb) {
        if (BoofConcurrency.USE_CONCURRENT) {
            if (buffer.getDataType() == 0 && ConvertRaster.isKnownByteFormat(dst)) {
                ImplConvertRaster_MT.interleavedToBuffered(src, (DataBufferByte)buffer, dst.getRaster());
                if (orderRgb) {
                    ImplConvertRaster_MT.orderBandsBufferedFromRGB((DataBufferByte)buffer, dst.getRaster(), dst.getType());
                }
            } else if (buffer.getDataType() == 3) {
                ImplConvertRaster_MT.interleavedToBuffered(src, (DataBufferInt)buffer, dst.getRaster());
                if (orderRgb) {
                    ImplConvertRaster_MT.orderBandsBufferedFromRGB((DataBufferInt)buffer, dst.getRaster(), dst.getType());
                }
            } else {
                ImplConvertRaster_MT.interleavedToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        } else {
            if (buffer.getDataType() == 0 && ConvertRaster.isKnownByteFormat(dst)) {
                ImplConvertRaster.interleavedToBuffered(src, (DataBufferByte)buffer, dst.getRaster());
                if (orderRgb) {
                    ImplConvertRaster.orderBandsBufferedFromRGB((DataBufferByte)buffer, dst.getRaster(), dst.getType());
                }
            } else if (buffer.getDataType() == 3) {
                ImplConvertRaster.interleavedToBuffered(src, (DataBufferInt)buffer, dst.getRaster());
                if (orderRgb) {
                    ImplConvertRaster.orderBandsBufferedFromRGB((DataBufferInt)buffer, dst.getRaster(), dst.getType());
                }
            } else {
                ImplConvertRaster.interleavedToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
    }

    public static int getOffset(WritableRaster raster) {
        if (raster.getWritableParent() == null) {
            return 0;
        }
        try {
            int min = Integer.MAX_VALUE;
            Method m = raster.getClass().getMethod("getDataOffset", Integer.TYPE);
            m.setAccessible(true);
            for (int i = 0; i < raster.getNumDataElements(); ++i) {
                min = Math.min(min, (Integer)m.invoke((Object)raster, i));
            }
            return min;
        }
        catch (IllegalAccessException | NoSuchMethodException | InaccessibleObjectException | InvocationTargetException e) {
            SampleModel sm = raster.getSampleModel();
            if (sm instanceof ComponentSampleModel) {
                ComponentSampleModel csm = (ComponentSampleModel)sm;
                return raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * csm.getScanlineStride() - raster.getSampleModelTranslateX() * csm.getPixelStride();
            }
            if (sm instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel smm = (SinglePixelPackedSampleModel)sm;
                return raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * smm.getScanlineStride() - raster.getSampleModelTranslateX();
            }
            if (sm instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel msm = (MultiPixelPackedSampleModel)sm;
                return raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * msm.getScanlineStride() - raster.getSampleModelTranslateX();
            }
            if (BoofMiscOps.getJavaVersion() >= 17) {
                throw new RuntimeException("Due to JRE encapsulation, low level data structures needed for fast conversion of BufferedImages are no longer accessible. You can work around this by adding the following to your java command: --add-exports=java.desktop/sun.awt.image=ALL-UNNAMED", e);
            }
            throw new IllegalArgumentException("BufferedImage subimages are not supported in Java 9 and beyond", e);
        }
    }

    public static <T extends ImageGray<T>> void orderBandsIntoRGB(Planar<T> image, BufferedImage input) {
        boolean swap = ConvertRaster.swapBandOrder(input);
        if (swap) {
            if (image.getNumBands() == 3) {
                int bufferedImageType = input.getType();
                if (bufferedImageType == 5 || bufferedImageType == 4) {
                    ImageGray tmp = image.getBand(0);
                    image.bands[0] = image.getBand(2);
                    image.bands[2] = tmp;
                }
            } else if (image.getNumBands() == 4) {
                ImageGray[] temp = (ImageGray[])Array.newInstance(image.getBandType(), 4);
                int bufferedImageType = input.getType();
                if (bufferedImageType == 2 || bufferedImageType == 3) {
                    temp[0] = image.getBand(1);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(3);
                    temp[3] = image.getBand(0);
                } else if (bufferedImageType == 6 || bufferedImageType == 7) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(0);
                }
                image.bands[0] = temp[0];
                image.bands[1] = temp[1];
                image.bands[2] = temp[2];
                image.bands[3] = temp[3];
            }
        }
    }

    public static <T extends ImageGray<T>> void orderBandsBufferedFromRgb(Planar<T> image, BufferedImage input) {
        boolean swap = ConvertRaster.swapBandOrder(input);
        if (swap) {
            if (image.getNumBands() == 3) {
                int bufferedImageType = input.getType();
                if (bufferedImageType == 5 || bufferedImageType == 4) {
                    ImageGray tmp = image.getBand(0);
                    image.bands[0] = image.getBand(2);
                    image.bands[2] = tmp;
                }
            } else if (image.getNumBands() == 4) {
                ImageGray[] temp = (ImageGray[])Array.newInstance(image.getBandType(), 4);
                int bufferedImageType = input.getType();
                if (bufferedImageType == 2 || bufferedImageType == 3) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(0);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(2);
                } else if (bufferedImageType == 6 || bufferedImageType == 7) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(0);
                }
                image.bands[0] = temp[0];
                image.bands[1] = temp[1];
                image.bands[2] = temp[2];
                image.bands[3] = temp[3];
            }
        }
    }

    public static void bufferedToGray(BufferedImage src, float[] data, int dstStartIndex, int dstStride) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToGray(src, data, dstStartIndex, dstStride);
        } else {
            ImplConvertRaster.bufferedToGray(src, data, dstStartIndex, dstStride);
        }
    }

    public static void bufferedToGray(BufferedImage src, byte[] data, int dstStartIndex, int dstStride) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToGray(src, data, dstStartIndex, dstStride);
        } else {
            ImplConvertRaster.bufferedToGray(src, data, dstStartIndex, dstStride);
        }
    }

    public static void bufferedToGray(DataBufferInt buffer, WritableRaster src, GrayU8 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToGray(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToGray(buffer, src, dst);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void orderBandsIntoRGB(ImageInterleaved image, BufferedImage input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            if (image instanceof InterleavedU8) {
                ImplConvertRaster_MT.orderBandsIntoRGB((InterleavedU8)image, input);
                return;
            } else {
                if (!(image instanceof InterleavedF32)) throw new IllegalArgumentException("Unsupported interleaved type");
                ImplConvertRaster_MT.orderBandsIntoRGB((InterleavedF32)image, input);
            }
            return;
        } else if (image instanceof InterleavedU8) {
            ImplConvertRaster.orderBandsIntoRGB((InterleavedU8)image, input);
            return;
        } else {
            if (!(image instanceof InterleavedF32)) throw new IllegalArgumentException("Unsupported interleaved type");
            ImplConvertRaster.orderBandsIntoRGB((InterleavedF32)image, input);
        }
    }

    public static boolean swapBandOrder(BufferedImage input) {
        int bufferedImageType = input.getType();
        return bufferedImageType == 5 || bufferedImageType == 4 || bufferedImageType == 2 || bufferedImageType == 6 || bufferedImageType == 3 || bufferedImageType == 7;
    }

    public static void interleavedToBuffered(InterleavedU8 src, BufferedImage dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.interleavedToBuffered(src, dst);
        } else {
            ImplConvertRaster.interleavedToBuffered(src, dst);
        }
    }

    public static void orderBandsBufferedFromRGB(DataBufferByte buffer, WritableRaster raster, int type) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.orderBandsBufferedFromRGB(buffer, raster, type);
        } else {
            ImplConvertRaster.orderBandsBufferedFromRGB(buffer, raster, type);
        }
    }

    public static void orderBandsBufferedFromRGB(DataBufferInt buffer, WritableRaster raster, int type) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.orderBandsBufferedFromRGB(buffer, raster, type);
        } else {
            ImplConvertRaster.orderBandsBufferedFromRGB(buffer, raster, type);
        }
    }

    public static void interleavedToBuffered(InterleavedU8 src, DataBufferByte buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.interleavedToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.interleavedToBuffered(src, buffer, dst);
        }
    }

    public static void interleavedToBuffered(InterleavedU8 src, DataBufferInt buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.interleavedToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.interleavedToBuffered(src, buffer, dst);
        }
    }

    public static void interleavedToBuffered(InterleavedF32 src, DataBufferByte buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.interleavedToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.interleavedToBuffered(src, buffer, dst);
        }
    }

    public static void interleavedToBuffered(InterleavedF32 src, DataBufferInt buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.interleavedToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.interleavedToBuffered(src, buffer, dst);
        }
    }

    public static void interleavedToBuffered(InterleavedF32 src, BufferedImage dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.interleavedToBuffered(src, dst);
        } else {
            ImplConvertRaster.interleavedToBuffered(src, dst);
        }
    }

    public static void planarToBuffered_U8(Planar<GrayU8> src, DataBufferByte buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.planarToBuffered_U8(src, buffer, dst);
        } else {
            ImplConvertRaster.planarToBuffered_U8(src, buffer, dst);
        }
    }

    public static void planarToBuffered_U8(Planar<GrayU8> src, DataBufferInt buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.planarToBuffered_U8(src, buffer, dst);
        } else {
            ImplConvertRaster.planarToBuffered_U8(src, buffer, dst);
        }
    }

    public static void planarToBuffered_U8(Planar<GrayU8> src, BufferedImage dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.planarToBuffered_U8(src, dst);
        } else {
            ImplConvertRaster.planarToBuffered_U8(src, dst);
        }
    }

    public static void grayToBuffered(GrayF32 src, DataBufferByte buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, buffer, dst);
        }
    }

    public static void grayToBuffered(GrayF32 src, DataBufferInt buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, buffer, dst);
        }
    }

    public static void grayToBuffered(GrayF32 src, BufferedImage dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, dst);
        }
    }

    public static void bufferedToPlanar_U8(DataBufferInt buffer, WritableRaster src, Planar<GrayU8> dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToPlanar_U8(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToPlanar_U8(buffer, src, dst);
        }
    }

    public static void bufferedToPlanar_U8(BufferedImage src, Planar<GrayU8> dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToPlanar_U8(src, dst);
        } else {
            ImplConvertRaster.bufferedToPlanar_U8(src, dst);
        }
    }

    public static void bufferedToPlanar_F32(DataBufferInt buffer, WritableRaster src, Planar<GrayF32> dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToPlanar_F32(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToPlanar_F32(buffer, src, dst);
        }
    }

    public static void bufferedToPlanar_F32(BufferedImage src, Planar<GrayF32> dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToPlanar_F32(src, dst);
        } else {
            ImplConvertRaster.bufferedToPlanar_F32(src, dst);
        }
    }

    public static void bufferedToInterleaved(DataBufferByte buffer, WritableRaster src, InterleavedU8 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToInterleaved(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToInterleaved(buffer, src, dst);
        }
    }

    public static void bufferedToInterleaved(BufferedImage src, InterleavedU8 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToInterleaved(src, dst);
        } else {
            ImplConvertRaster.bufferedToInterleaved(src, dst);
        }
    }

    public static void bufferedToInterleaved(DataBufferInt buffer, WritableRaster src, InterleavedU8 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToInterleaved(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToInterleaved(buffer, src, dst);
        }
    }

    public static void bufferedToInterleaved(DataBufferByte buffer, WritableRaster src, InterleavedF32 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToInterleaved(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToInterleaved(buffer, src, dst);
        }
    }

    public static void bufferedToInterleaved(BufferedImage src, InterleavedF32 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToInterleaved(src, dst);
        } else {
            ImplConvertRaster.bufferedToInterleaved(src, dst);
        }
    }

    public static void bufferedToInterleaved(DataBufferInt buffer, WritableRaster src, InterleavedF32 dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.bufferedToInterleaved(buffer, src, dst);
        } else {
            ImplConvertRaster.bufferedToInterleaved(buffer, src, dst);
        }
    }

    public static void grayToBuffered(GrayU8 src, DataBufferByte buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, buffer, dst);
        }
    }

    public static void grayToBuffered(GrayU8 src, DataBufferInt buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, buffer, dst);
        }
    }

    public static void grayToBuffered(GrayU8 src, BufferedImage dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, dst);
        }
    }

    public static void grayToBuffered(GrayI16 src, DataBufferByte buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, buffer, dst);
        }
    }

    public static void grayToBuffered(GrayI16 src, DataBufferUShort buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, buffer, dst);
        }
    }

    public static void grayToBuffered(GrayI16 src, DataBufferInt buffer, WritableRaster dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, buffer, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, buffer, dst);
        }
    }

    public static void grayToBuffered(GrayI16 src, BufferedImage dst) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertRaster_MT.grayToBuffered(src, dst);
        } else {
            ImplConvertRaster.grayToBuffered(src, dst);
        }
    }

    public static boolean isKnownByteFormat(BufferedImage image) {
        int type = image.getType();
        return type != 13 && type != 12 && type != 0;
    }
}

