/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper;

import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.WebcamInterface;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class DynamicWebcamInterface
implements WebcamInterface {
    WebcamInterface webcam;

    public DynamicWebcamInterface() {
        try {
            this.webcam = DynamicWebcamInterface.loadManager("boofcv.io.webcamcapture.WebcamCaptureWebcamInterface");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public <T extends ImageBase<T>> SimpleImageSequence<T> open(String device, int width, int height, ImageType<T> imageType) {
        if (this.webcam == null) {
            throw new RuntimeException("No webcam libraries loaded");
        }
        return this.webcam.open(device, width, height, imageType);
    }

    public static WebcamInterface loadManager(String pathToManager) {
        try {
            Class<?> c = Class.forName(pathToManager);
            return (WebcamInterface)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found.  Is it included in the class path?");
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

