/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.calibration;

import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.calib.VisualDepthParameters;
import georegression.struct.se.Se3_F64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class CalibrationIO {
    public static String MODEL_PINHOLE = "pinhole";
    public static String MODEL_PINHOLE_RADIAL_TAN = "pinhole_radial_tangential";
    public static String MODEL_OMNIDIRECTIONAL_UNIVERSAL = "omnidirectional_universal";
    public static String MODEL_STEREO = "stereo_camera";
    public static String MODEL_RIGID_BODY = "rigid_body";
    public static String MODEL_VISUAL_DEPTH = "visual_depth";
    public static String MODEL_MONO_PLANE = "monocular_plane";
    public static String VERSION = "version";

    public static <T extends CameraPinhole> void save(T parameters, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (parameters instanceof CameraPinholeRadial) {
            out.println("# Pinhole camera model with radial and tangential distortion");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println("# radial = radial distortion, (t1,t2) = tangential distortion");
            out.println();
            CalibrationIO.putModelRadial((CameraPinholeRadial)parameters, data);
        } else if (parameters instanceof CameraUniversalOmni) {
            out.println("# Omnidirectional camera model with radial and tangential distortion");
            out.println("# C. Mei, and P. Rives. \"Single view point omnidirectional camera calibration from planar grids.\"  ICRA 2007");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println("# mirror_offset = offset mirror along z-axis in unit circle");
            out.println("# radial = radial distortion, (t1,t2) = tangential distortion");
            out.println();
            CalibrationIO.putModelUniversalOmni((CameraUniversalOmni)parameters, data);
        } else {
            out.println("# Pinhole camera model");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println();
            CalibrationIO.putModelPinhole(parameters, data);
        }
        yaml.dump(data, (Writer)out);
        out.close();
    }

    public static <T extends CameraPinhole> void save(T parameters, String filePath) {
        try {
            CalibrationIO.save(parameters, (Writer)new FileWriter(filePath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends CameraPinhole> void save(T parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    private static Yaml createYmlObject() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(options);
    }

    public static void save(StereoParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_STEREO);
        map.put(VERSION, 0);
        map.put("left", CalibrationIO.putModelRadial(parameters.left, null));
        map.put("right", CalibrationIO.putModelRadial(parameters.right, null));
        map.put("rightToLeft", CalibrationIO.putSe3(parameters.rightToLeft));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Intrinsic and extrinsic parameters for a stereo camera pair");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.close();
    }

    public static void save(StereoParameters parameters, String outputPath) {
        try {
            CalibrationIO.save(parameters, (Writer)new FileWriter(outputPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void save(StereoParameters parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    public static void save(Se3_F64 rigidBody, File filePath) {
        CalibrationIO.save(rigidBody, filePath.getPath());
    }

    public static void save(Se3_F64 rigidBody, String outputPath) {
        try {
            CalibrationIO.save(rigidBody, (Writer)new FileWriter(outputPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void save(Se3_F64 rigidBody, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_RIGID_BODY);
        map.put(VERSION, 0);
        map.put("parameters", CalibrationIO.putSe3(rigidBody));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Rigid Body transformation");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.close();
    }

    public static void save(VisualDepthParameters parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    public static void save(VisualDepthParameters parameters, String outputPath) {
        try {
            CalibrationIO.save(parameters, (Writer)new FileWriter(outputPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void save(VisualDepthParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_VISUAL_DEPTH);
        map.put(VERSION, 0);
        map.put("max_depth", parameters.getMaxDepth());
        map.put("no_depth", parameters.getPixelNoDepth());
        map.put("intrinsic", CalibrationIO.putModelRadial(parameters.getVisualParam(), null));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# RGB Depth Camera Calibration");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.close();
    }

    public static void save(MonoPlaneParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_MONO_PLANE);
        map.put(VERSION, 0);
        map.put("intrinsic", CalibrationIO.putModelRadial(parameters.getIntrinsic(), null));
        map.put("plane_to_camera", CalibrationIO.putSe3(parameters.getPlaneToCamera()));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Monocular Camera with Known Plane Distance");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.close();
    }

    public static <T> T load(URL path) {
        try {
            return CalibrationIO.load(new InputStreamReader(path.openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T load(File path) {
        try {
            return CalibrationIO.load(new FileReader(path));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T load(String path) {
        try {
            return CalibrationIO.load(new FileReader(path));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T load(Reader reader) {
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return CalibrationIO.load(data);
    }

    private static <T> T load(Map<String, Object> data) {
        int version = data.containsKey("version") ? (Integer)data.get("version") : 0;
        String model = (String)data.get("model");
        if (model.equals(MODEL_PINHOLE)) {
            CameraPinhole parameters = new CameraPinhole();
            CalibrationIO.loadPinhole((Map)data.get("pinhole"), parameters);
            return (T)parameters;
        }
        if (model.equals(MODEL_PINHOLE_RADIAL_TAN)) {
            List list;
            CameraPinholeRadial parameters = new CameraPinholeRadial();
            CalibrationIO.loadPinhole((Map)data.get("pinhole"), (CameraPinhole)parameters);
            Map distortion = (Map)data.get("radial_tangential");
            if (distortion.containsKey("radial") && (list = (List)distortion.get("radial")) != null) {
                parameters.radial = new double[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    parameters.radial[i] = (Double)list.get(i);
                }
            }
            if (distortion.containsKey("t1")) {
                parameters.t1 = (Double)distortion.get("t1");
            }
            if (distortion.containsKey("t2")) {
                parameters.t2 = (Double)distortion.get("t2");
            }
            return (T)parameters;
        }
        if (model.equals(MODEL_OMNIDIRECTIONAL_UNIVERSAL)) {
            List list;
            CameraUniversalOmni parameters = new CameraUniversalOmni(0);
            CalibrationIO.loadPinhole((Map)data.get("pinhole"), (CameraPinhole)parameters);
            parameters.mirrorOffset = (Double)data.get("mirror_offset");
            Map distortion = (Map)data.get("radial_tangential");
            if (distortion.containsKey("radial") && (list = (List)distortion.get("radial")) != null) {
                parameters.radial = new double[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    parameters.radial[i] = (Double)list.get(i);
                }
            }
            if (distortion.containsKey("t1")) {
                parameters.t1 = (Double)distortion.get("t1");
            }
            if (distortion.containsKey("t2")) {
                parameters.t2 = (Double)distortion.get("t2");
            }
            return (T)parameters;
        }
        if (model.equals(MODEL_STEREO)) {
            StereoParameters parameters = new StereoParameters();
            parameters.left = (CameraPinholeRadial)CalibrationIO.load((Map)data.get("left"));
            parameters.right = (CameraPinholeRadial)CalibrationIO.load((Map)data.get("right"));
            parameters.rightToLeft = CalibrationIO.loadSe3((Map)data.get("rightToLeft"), null);
            return (T)parameters;
        }
        if (model.equals(MODEL_VISUAL_DEPTH)) {
            VisualDepthParameters parameters = new VisualDepthParameters();
            parameters.maxDepth = (Number)data.get("max_depth");
            parameters.pixelNoDepth = (Number)data.get("no_depth");
            parameters.visualParam = (CameraPinholeRadial)CalibrationIO.load((Map)data.get("intrinsic"));
            return (T)parameters;
        }
        if (model.equals(MODEL_MONO_PLANE)) {
            MonoPlaneParameters parameters = new MonoPlaneParameters();
            parameters.intrinsic = (CameraPinholeRadial)CalibrationIO.load((Map)data.get("intrinsic"));
            parameters.planeToCamera = CalibrationIO.loadSe3((Map)data.get("plane_to_camera"), null);
            return (T)parameters;
        }
        if (model.equals(MODEL_RIGID_BODY)) {
            return (T)CalibrationIO.loadSe3((Map)data.get("parameters"), null);
        }
        throw new RuntimeException("Unknown camera model: " + model);
    }

    private static Map<String, Object> putModelPinhole(CameraPinhole parameters, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_PINHOLE);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole(parameters));
        return map;
    }

    private static Map<String, Object> putModelRadial(CameraPinholeRadial parameters, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_PINHOLE_RADIAL_TAN);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole((CameraPinhole)parameters));
        map.put("radial_tangential", CalibrationIO.putParamsRadialTangent(parameters));
        return map;
    }

    private static Map<String, Object> putModelUniversalOmni(CameraUniversalOmni parameters, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_OMNIDIRECTIONAL_UNIVERSAL);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole((CameraPinhole)parameters));
        map.put("mirror_offset", parameters.mirrorOffset);
        HashMap<String, Object> mapDistort = new HashMap<String, Object>();
        if (parameters.radial != null) {
            mapDistort.put("radial", parameters.radial);
        }
        mapDistort.put("t1", parameters.t1);
        mapDistort.put("t2", parameters.t2);
        map.put("radial_tangential", mapDistort);
        return map;
    }

    private static Map<String, Object> putParamsPinhole(CameraPinhole parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", parameters.width);
        map.put("height", parameters.height);
        map.put("fx", parameters.fx);
        map.put("fy", parameters.fy);
        map.put("skew", parameters.skew);
        map.put("cx", parameters.cx);
        map.put("cy", parameters.cy);
        return map;
    }

    private static Map<String, Object> putParamsRadialTangent(CameraPinholeRadial parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (parameters.radial != null) {
            map.put("radial", parameters.radial);
        }
        map.put("t1", parameters.t1);
        map.put("t2", parameters.t2);
        return map;
    }

    private static Map<String, Object> putSe3(Se3_F64 transform) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rotation", transform.R.data);
        map.put("x", transform.T.x);
        map.put("y", transform.T.y);
        map.put("z", transform.T.z);
        return map;
    }

    private static void loadPinhole(Map<String, Object> map, CameraPinhole parameters) {
        parameters.width = (Integer)map.get("width");
        parameters.height = (Integer)map.get("height");
        parameters.fx = (Double)map.get("fx");
        parameters.fy = (Double)map.get("fy");
        parameters.skew = (Double)map.get("skew");
        parameters.cx = (Double)map.get("cx");
        parameters.cy = (Double)map.get("cy");
    }

    private static Se3_F64 loadSe3(Map<String, Object> map, Se3_F64 transform) {
        if (transform == null) {
            transform = new Se3_F64();
        }
        List rotation = (List)map.get("rotation");
        transform.T.x = (Double)map.get("x");
        transform.T.y = (Double)map.get("y");
        transform.T.z = (Double)map.get("z");
        for (int i = 0; i < 9; ++i) {
            transform.R.data[i] = (Double)rotation.get(i);
        }
        return transform;
    }
}

