/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import java.io.Serializable;
import org.ejml.FancyPrint;

public class CameraDivision
extends CameraPinhole
implements Serializable {
    public double radial;

    @Override
    public void reset() {
        super.reset();
        this.radial = 0.0;
    }

    @Override
    public CameraDivision fsetK(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        return (CameraDivision)super.fsetK(fx, fy, skew, cx, cy, width, height);
    }

    public CameraDivision fsetRadial(double radial) {
        this.radial = radial;
        return this;
    }

    @Override
    public <T extends CameraModel> T createLike() {
        return (T)new CameraDivision();
    }

    public CameraDivision setTo(CameraDivision param) {
        this.radial = param.radial;
        super.setTo(param);
        return this;
    }

    @Override
    public CameraPinhole setTo(CameraPinhole param) {
        if (param instanceof CameraDivision) {
            this.setTo((CameraDivision)param);
        } else {
            this.radial = 0.0;
            super.setTo(param);
        }
        return this;
    }

    public boolean isDistorted() {
        return this.radial != 0.0;
    }

    @Override
    public void print() {
        super.print();
        System.out.printf("radial=%6.2e%n\n", this.radial);
    }

    @Override
    public String toString() {
        FancyPrint fp = new FancyPrint();
        String txt = "CameraDivision{fx=" + this.fx + ", fy=" + this.fy + ", skew=" + this.skew + ", cx=" + this.cx + ", cy=" + this.cy + ", width=" + this.width + ", height=" + this.height + ", radial=" + fp.s(this.radial);
        txt = txt + "}";
        return txt;
    }

    public double getRadial() {
        return this.radial;
    }
}

