/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.alg.geo.PerspectiveOps;
import georegression.struct.point.Vector3D_F64;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF3;

public class EstimatePlaneAtInfinityGivenK {
    DMatrix3x3 Q2 = new DMatrix3x3();
    DMatrix3 q2 = new DMatrix3();
    DMatrix3x3 K1 = new DMatrix3x3();
    DMatrix3x3 K2 = new DMatrix3x3();
    DMatrix3x3 K2_inv = new DMatrix3x3();
    DMatrix3 t2 = new DMatrix3();
    DMatrix3x3 RR = new DMatrix3x3();
    DMatrix3x3 tmpA = new DMatrix3x3();
    DMatrix3x3 tmpB = new DMatrix3x3();
    DMatrix3x3 W = new DMatrix3x3();
    Vector3D_F64 w2 = new Vector3D_F64();
    Vector3D_F64 w3 = new Vector3D_F64();

    public void setCamera1(double fx, double fy, double skew, double cx, double cy) {
        PerspectiveOps.pinholeToMatrix(fx, fy, skew, cx, cy, this.K1);
    }

    public void setCamera2(double fx, double fy, double skew, double cx, double cy) {
        PerspectiveOps.pinholeToMatrix(fx, fy, skew, cx, cy, this.K2);
        PerspectiveOps.invertPinhole(this.K2, this.K2_inv);
    }

    public boolean estimatePlaneAtInfinity(DMatrixRMaj P2, Vector3D_F64 v) {
        PerspectiveOps.projectionSplit(P2, this.Q2, this.q2);
        CommonOps_DDF3.mult((DMatrix3x3)this.K2_inv, (DMatrix3)this.q2, (DMatrix3)this.t2);
        CommonOps_DDF3.mult((DMatrix3x3)this.K2_inv, (DMatrix3x3)this.Q2, (DMatrix3x3)this.tmpA);
        CommonOps_DDF3.mult((DMatrix3x3)this.tmpA, (DMatrix3x3)this.K1, (DMatrix3x3)this.tmpB);
        EstimatePlaneAtInfinityGivenK.computeRotation(this.t2, this.RR);
        CommonOps_DDF3.mult((DMatrix3x3)this.RR, (DMatrix3x3)this.tmpB, (DMatrix3x3)this.W);
        this.w2.setTo(this.W.a21, this.W.a22, this.W.a23);
        this.w3.setTo(this.W.a31, this.W.a32, this.W.a33);
        double n3 = this.w3.norm();
        v.crossSetTo(this.w2, this.w3);
        v.divideIP(n3);
        v.x -= this.W.a11;
        v.y -= this.W.a12;
        v.z -= this.W.a13;
        v.divideIP(this.t2.a1);
        return !UtilEjml.isUncountable((double)v.x) && !UtilEjml.isUncountable((double)v.y) && !UtilEjml.isUncountable((double)v.z);
    }

    static void computeRotation(DMatrix3 t, DMatrix3x3 R) {
        for (int i = 1; i >= 0; --i) {
            double a = t.get(i, 0);
            double b = t.get(i + 1, 0);
            double r = Math.sqrt(a * a + b * b);
            double q11 = a / r;
            double q21 = b / r;
            t.set(i, 0, r);
            t.set(i + 1, 0, 0.0);
            if (i == 1) {
                R.a11 = 1.0;
                R.a12 = 0.0;
                R.a13 = 0.0;
                R.a21 = 0.0;
                R.a22 = q11;
                R.a23 = q21;
                R.a31 = 0.0;
                R.a32 = -q21;
                R.a33 = q11;
                continue;
            }
            R.a11 = q11;
            R.a12 = R.a22 * q21;
            R.a13 = R.a23 * q21;
            R.a21 = -q21;
            R.a22 *= q11;
            R.a23 *= q11;
        }
    }
}

