/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;

public class PoseFromPairLinear6 {
    private DMatrixRMaj A = new DMatrixRMaj(1, 12);
    private SolveNullSpace<DMatrixRMaj> solveNullspace = new SolveNullSpaceSvd_DDRM();
    private DMatrixRMaj P = new DMatrixRMaj(3, 4);

    public boolean process(List<AssociatedPair> observations, List<Point3D_F64> locations) {
        if (observations.size() != locations.size()) {
            throw new IllegalArgumentException("Number of observations and locations must match.");
        }
        if (observations.size() < 6) {
            throw new IllegalArgumentException("At least (if not more than) six points are required.");
        }
        this.setupA(observations, locations);
        if (!this.solveNullspace.process((Matrix)this.A, 1, (Matrix)this.P)) {
            return false;
        }
        this.P.numRows = 3;
        this.P.numCols = 4;
        return true;
    }

    public boolean processHomogeneous(List<AssociatedPair> observations, List<Point4D_F64> locations) {
        if (observations.size() != locations.size()) {
            throw new IllegalArgumentException("Number of observations and locations must match.");
        }
        if (observations.size() < 6) {
            throw new IllegalArgumentException("At least (if not more than) six points are required.");
        }
        this.setupHomogeneousA(observations, locations);
        if (!this.solveNullspace.process((Matrix)this.A, 1, (Matrix)this.P)) {
            return false;
        }
        this.P.numRows = 3;
        this.P.numCols = 4;
        return true;
    }

    public DMatrixRMaj getProjective() {
        return this.P;
    }

    protected DMatrixRMaj getA() {
        return this.A;
    }

    private void setupA(List<AssociatedPair> observations, List<Point3D_F64> locations) {
        this.A.reshape(2 * observations.size(), 12, false);
        for (int i = 0; i < observations.size(); ++i) {
            AssociatedPair p = observations.get(i);
            Point3D_F64 loc = locations.get(i);
            Point2D_F64 pt1 = p.p1;
            Point2D_F64 pt2 = p.p2;
            int w = i * 2;
            double alpha = 1.0 / loc.z;
            this.A.set(w, 4, -pt1.x);
            this.A.set(w, 5, -pt1.y);
            this.A.set(w, 6, -1.0);
            this.A.set(w, 8, pt2.y * pt1.x);
            this.A.set(w, 9, pt2.y * pt1.y);
            this.A.set(w, 10, pt2.y);
            this.A.set(w, 3, 0.0);
            this.A.set(w, 7, -alpha);
            this.A.set(w, 11, alpha * pt2.y);
            this.A.set(++w, 0, pt1.x);
            this.A.set(w, 1, pt1.y);
            this.A.set(w, 2, 1.0);
            this.A.set(w, 8, -pt2.x * pt1.x);
            this.A.set(w, 9, -pt2.x * pt1.y);
            this.A.set(w, 10, -pt2.x);
            this.A.set(w, 3, alpha);
            this.A.set(w, 7, 0.0);
            this.A.set(w, 11, -alpha * pt2.x);
        }
    }

    private void setupHomogeneousA(List<AssociatedPair> observations, List<Point4D_F64> locations) {
        this.A.reshape(2 * observations.size(), 12, false);
        for (int i = 0; i < observations.size(); ++i) {
            AssociatedPair p = observations.get(i);
            Point4D_F64 loc = locations.get(i);
            Point2D_F64 pt1 = p.p1;
            Point2D_F64 pt2 = p.p2;
            int w = i * 2;
            double alpha = loc.w / loc.z;
            this.A.set(w, 4, -pt1.x);
            this.A.set(w, 5, -pt1.y);
            this.A.set(w, 6, -1.0);
            this.A.set(w, 8, pt2.y * pt1.x);
            this.A.set(w, 9, pt2.y * pt1.y);
            this.A.set(w, 10, pt2.y);
            this.A.set(w, 3, 0.0);
            this.A.set(w, 7, -alpha);
            this.A.set(w, 11, alpha * pt2.y);
            this.A.set(++w, 0, pt1.x);
            this.A.set(w, 1, pt1.y);
            this.A.set(w, 2, 1.0);
            this.A.set(w, 8, -pt2.x * pt1.x);
            this.A.set(w, 9, -pt2.x * pt1.y);
            this.A.set(w, 10, -pt2.x);
            this.A.set(w, 3, alpha);
            this.A.set(w, 7, 0.0);
            this.A.set(w, 11, -alpha * pt2.x);
        }
    }
}

