/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.BundleCameraState;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.Point2D4D;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.ejml.UtilEjml;
import org.jetbrains.annotations.Nullable;

public class PnPRefineWithPixels4D
implements VerbosePrint {
    BundleAdjustment<SceneStructureMetric> bundleAdjustment = FactoryMultiView.bundleDenseMetric(false, null);
    SceneStructureMetric structure = new SceneStructureMetric(true);
    SceneObservations sceneObs = new SceneObservations();
    @Nullable
    BundleCameraState cameraState;
    @Nullable
    BundleAdjustmentCamera camera;
    Se3_F64 identity = new Se3_F64();
    @Nullable
    PrintStream verbose = null;

    public PnPRefineWithPixels4D() {
        this.bundleAdjustment.configure(1.0E-8, 1.0E-8, 20);
    }

    public void setCamera(BundleAdjustmentCamera camera, @Nullable BundleCameraState state) {
        this.camera = camera;
        this.cameraState = state;
    }

    public boolean refine(List<Point2D4D> observations, Se3_F64 initial, Se3_F64 output) {
        Point4D_F64 p;
        int i;
        if (this.camera == null) {
            throw new RuntimeException("Must first call setCamera");
        }
        this.structure.initialize(1, 1, 1, 0, 1);
        this.sceneObs.initialize(1, true);
        this.structure.setCamera(0, true, this.camera);
        this.structure.setRigid(0, true, this.identity, observations.size());
        for (i = 0; i < observations.size(); ++i) {
            p = observations.get((int)i).location;
            this.structure.getRigid(0).setPoint(i, p.x, p.y, p.z, p.w);
        }
        this.structure.setView(0, 0, false, initial);
        this.structure.assignIDsToRigidPoints();
        for (i = 0; i < observations.size(); ++i) {
            p = observations.get((int)i).observation;
            this.structure.getRigid(0).connectPointToView(i, 0, (float)p.x, (float)p.y, this.sceneObs);
        }
        this.sceneObs.getView((int)0).cameraState = this.cameraState;
        this.bundleAdjustment.setParameters(this.structure, this.sceneObs);
        if (this.bundleAdjustment.optimize(this.structure)) {
            output.setTo(this.structure.getParentToView(0));
        } else {
            output.setTo(initial);
        }
        return !UtilEjml.isUncountable((double)this.bundleAdjustment.getFitScore());
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
        VerboseUtils.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.bundleAdjustment});
    }

    public BundleAdjustment<SceneStructureMetric> getBundleAdjustment() {
        return this.bundleAdjustment;
    }

    public void setBundleAdjustment(BundleAdjustment<SceneStructureMetric> bundleAdjustment) {
        this.bundleAdjustment = bundleAdjustment;
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public SceneObservations getSceneObs() {
        return this.sceneObs;
    }
}

