/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class Zhang99ComputeTargetHomography {
    public static int MINIMUM_POINTS = 4;
    private final Estimate1ofEpipolar computeHomography = FactoryMultiView.homographyDLT(true);
    private final DMatrixRMaj found = new DMatrixRMaj(3, 3);
    @Nullable
    List<Point2D_F64> targetLayout;

    public boolean computeHomography(List<PointIndex2D_F64> observedPoints) {
        Objects.requireNonNull(this.targetLayout, "Must specify targetLayout first");
        if (observedPoints.size() < MINIMUM_POINTS) {
            throw new IllegalArgumentException("At least 4 points needed in each set of observations.  Filter these first please");
        }
        ArrayList<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
        for (int i = 0; i < observedPoints.size(); ++i) {
            int which = observedPoints.get((int)i).index;
            Point2D_F64 obs = (Point2D_F64)observedPoints.get((int)i).p;
            pairs.add(new AssociatedPair(this.targetLayout.get(which), obs, true));
        }
        return this.computeHomography.process(pairs, this.found);
    }

    public DMatrixRMaj getCopyOfHomography() {
        return this.found.copy();
    }

    public void setTargetLayout(@Nullable List<Point2D_F64> targetLayout) {
        this.targetLayout = targetLayout;
    }
}

