/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.jacobians;

import boofcv.alg.geo.bundle.jacobians.JacobianSo3;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.so.Quaternion_F64;
import org.ejml.data.DMatrixRMaj;

public class JacobianSo3Quaternions
implements JacobianSo3 {
    private final Quaternion_F64 quat = new Quaternion_F64();
    private final DMatrixRMaj R = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj[] jacR = new DMatrixRMaj[4];

    public JacobianSo3Quaternions() {
        for (int i = 0; i < this.jacR.length; ++i) {
            this.jacR[i] = new DMatrixRMaj(3, 3);
        }
    }

    @Override
    public void getParameters(DMatrixRMaj R, double[] parameters, int offset) {
        ConvertRotation3D_F64.matrixToQuaternion((DMatrixRMaj)R, (Quaternion_F64)this.quat);
        parameters[offset] = this.quat.w;
        parameters[offset + 1] = this.quat.x;
        parameters[offset + 2] = this.quat.y;
        parameters[offset + 3] = this.quat.z;
    }

    @Override
    public void setParameters(double[] parameters, int offset) {
        this.quat.w = parameters[offset];
        this.quat.x = parameters[offset + 1];
        this.quat.y = parameters[offset + 2];
        this.quat.z = parameters[offset + 3];
        this.quat.normalize();
        ConvertRotation3D_F64.quaternionToMatrix((Quaternion_F64)this.quat, (DMatrixRMaj)this.R);
        this.computeJacobians();
    }

    protected void computeJacobians() {
        double w = this.quat.w;
        double x = this.quat.x;
        double y = this.quat.y;
        double z = this.quat.z;
        double r2 = w * w + x * x + y * y + z * z;
        double r = Math.sqrt(r2);
        double d_r = -2.0 / r2;
        double R00 = (w /= r) * w + (x /= r) * x - (y /= r) * y - (z /= r) * z;
        double R01 = 2.0 * (x * y - w * z);
        double R02 = 2.0 * (x * z + w * y);
        double R10 = 2.0 * (x * y + w * z);
        double R11 = w * w - x * x + y * y - z * z;
        double R12 = 2.0 * (y * z - w * x);
        double R20 = 2.0 * (x * z - w * y);
        double R21 = 2.0 * (y * z + w * x);
        double R22 = w * w - x * x - y * y + z * z;
        DMatrixRMaj Rw = this.jacR[0];
        Rw.data[0] = 2.0 * w / r + R00 * w * d_r;
        Rw.data[1] = -2.0 * z / r + R01 * w * d_r;
        Rw.data[2] = 2.0 * y / r + R02 * w * d_r;
        Rw.data[3] = 2.0 * z / r + R10 * w * d_r;
        Rw.data[4] = 2.0 * w / r + R11 * w * d_r;
        Rw.data[5] = -2.0 * x / r + R12 * w * d_r;
        Rw.data[6] = -2.0 * y / r + R20 * w * d_r;
        Rw.data[7] = 2.0 * x / r + R21 * w * d_r;
        Rw.data[8] = 2.0 * w / r + R22 * w * d_r;
        DMatrixRMaj Rx = this.jacR[1];
        Rx.data[0] = 2.0 * x / r + R00 * x * d_r;
        Rx.data[1] = 2.0 * y / r + R01 * x * d_r;
        Rx.data[2] = 2.0 * z / r + R02 * x * d_r;
        Rx.data[3] = 2.0 * y / r + R10 * x * d_r;
        Rx.data[4] = -2.0 * x / r + R11 * x * d_r;
        Rx.data[5] = -2.0 * w / r + R12 * x * d_r;
        Rx.data[6] = 2.0 * z / r + R20 * x * d_r;
        Rx.data[7] = 2.0 * w / r + R21 * x * d_r;
        Rx.data[8] = -2.0 * x / r + R22 * x * d_r;
        DMatrixRMaj Ry = this.jacR[2];
        Ry.data[0] = -2.0 * y / r + R00 * y * d_r;
        Ry.data[1] = 2.0 * x / r + R01 * y * d_r;
        Ry.data[2] = 2.0 * w / r + R02 * y * d_r;
        Ry.data[3] = 2.0 * x / r + R10 * y * d_r;
        Ry.data[4] = 2.0 * y / r + R11 * y * d_r;
        Ry.data[5] = 2.0 * z / r + R12 * y * d_r;
        Ry.data[6] = -2.0 * w / r + R20 * y * d_r;
        Ry.data[7] = 2.0 * z / r + R21 * y * d_r;
        Ry.data[8] = -2.0 * y / r + R22 * y * d_r;
        DMatrixRMaj Rz = this.jacR[3];
        Rz.data[0] = -2.0 * z / r + R00 * z * d_r;
        Rz.data[1] = -2.0 * w / r + R01 * z * d_r;
        Rz.data[2] = 2.0 * x / r + R02 * z * d_r;
        Rz.data[3] = 2.0 * w / r + R10 * z * d_r;
        Rz.data[4] = -2.0 * z / r + R11 * z * d_r;
        Rz.data[5] = 2.0 * y / r + R12 * z * d_r;
        Rz.data[6] = 2.0 * x / r + R20 * z * d_r;
        Rz.data[7] = 2.0 * y / r + R21 * z * d_r;
        Rz.data[8] = 2.0 * z / r + R22 * z * d_r;
    }

    @Override
    public int getParameterLength() {
        return 4;
    }

    @Override
    public DMatrixRMaj getRotationMatrix() {
        return this.R;
    }

    @Override
    public DMatrixRMaj getPartial(int param) {
        return this.jacR[param];
    }

    @Override
    public JacobianSo3 newInstance() {
        return new JacobianSo3Quaternions();
    }
}

