/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Point2D_F64;

public class NormalizedToPinholePixelError {
    private double fx;
    private double fy;
    private double skew;

    public NormalizedToPinholePixelError(double fx, double fy, double skew) {
        this.setTo(fx, fy, skew);
    }

    public NormalizedToPinholePixelError() {
    }

    public void setTo(double fx, double fy, double skew) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
    }

    public double errorSq(Point2D_F64 a, Point2D_F64 b) {
        double dy = b.y - a.y;
        double dx = (b.x - a.x) * this.fx + dy * this.skew;
        return dx * dx + (dy *= this.fy) * dy;
    }

    public double errorSq(double a_x, double a_y, double b_x, double b_y) {
        double dy = b_y - a_y;
        double dx = (b_x - a_x) * this.fx + dy * this.skew;
        return dx * dx + (dy *= this.fy) * dy;
    }

    public void residuals(Point2D_F64 a, Point2D_F64 b, Point2D_F64 error) {
        double dy = b.y - a.y;
        double dx = (b.x - a.x) * this.fx + dy * this.skew;
        error.setTo(dx, dy *= this.fy);
    }

    public void residuals(double a_x, double a_y, double b_x, double b_y, Point2D_F64 error) {
        double dy = b_y - a_y;
        double dx = (b_x - a_x) * this.fx + dy * this.skew;
        error.setTo(dx, dy *= this.fy);
    }
}

