/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.alg.geo.GeometricResult;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.selfcalib.SelfCalibrationBase;
import boofcv.alg.geo.structure.DecomposeAbsoluteDualQuadratic;
import boofcv.struct.calib.CameraPinhole;
import java.util.Arrays;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrix4x4;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.fixed.CommonOps_DDF4;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class SelfCalibrationLinearDualQuadratic
extends SelfCalibrationBase {
    SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((int)10, (int)10, (boolean)false, (boolean)true, (boolean)true);
    public DecomposeAbsoluteDualQuadratic decomposeADQ = new DecomposeAbsoluteDualQuadratic();
    public boolean knownAspect;
    public boolean zeroSkew;
    int eqs;
    double aspectRatio;
    DogArray<Intrinsic> solutions = new DogArray(Intrinsic::new);
    DMatrix4x4 Q = new DMatrix4x4();
    double singularThreshold = 0.001;
    private final DMatrixRMaj L = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj w_i = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj nv = new DMatrixRMaj(10, 1);

    public SelfCalibrationLinearDualQuadratic(boolean zeroSkew) {
        this(zeroSkew ? 3 : 2);
        this.knownAspect = false;
        this.zeroSkew = zeroSkew;
    }

    public SelfCalibrationLinearDualQuadratic(double aspectRatio) {
        this(4);
        this.knownAspect = true;
        this.zeroSkew = true;
        this.aspectRatio = aspectRatio;
    }

    private SelfCalibrationLinearDualQuadratic(int equations) {
        this.eqs = equations;
        this.minimumProjectives = (int)Math.ceil(10.0 / (double)this.eqs);
    }

    public void reset() {
        this.cameras.reset();
    }

    public GeometricResult solve() {
        this.solutions.reset();
        if (this.cameras.size < this.minimumProjectives) {
            throw new IllegalArgumentException("You need at least " + this.minimumProjectives + " motions");
        }
        int N = this.cameras.size;
        this.L.reshape(N * this.eqs, 10);
        this.constructMatrix(this.L);
        if (!this.svd.decompose((Matrix)this.L)) {
            return GeometricResult.SOLVE_FAILED;
        }
        SingularOps_DDRM.nullVector(this.svd, (boolean)true, (DMatrixRMaj)this.nv);
        double[] sv = this.svd.getSingularValues();
        Arrays.sort(sv);
        if (this.singularThreshold * sv[1] <= sv[0]) {
            return GeometricResult.GEOMETRY_POOR;
        }
        if (!this.extractSolutionForQ(this.Q)) {
            return GeometricResult.SOLVE_FAILED;
        }
        if (!MultiViewOps.enforceAbsoluteQuadraticConstraints(this.Q, true, this.zeroSkew, this.decomposeADQ)) {
            return GeometricResult.SOLVE_FAILED;
        }
        this.computeSolutions(this.Q);
        if (this.solutions.size() != N) {
            return GeometricResult.SOLUTION_NAN;
        }
        return GeometricResult.SUCCESS;
    }

    private boolean extractSolutionForQ(DMatrix4x4 Q) {
        SelfCalibrationLinearDualQuadratic.encodeQ(Q, this.nv.data);
        if (Q.a11 < 0.0 || Q.a22 < 0.0 || Q.a33 < 0.0) {
            CommonOps_DDF4.scale((double)-1.0, (DMatrix4x4)Q);
        }
        return true;
    }

    private void computeSolutions(DMatrix4x4 Q) {
        for (int i = 0; i < this.cameras.size; ++i) {
            this.computeW((SelfCalibrationBase.Projective)this.cameras.get(i), Q, this.w_i);
            Intrinsic calib = (Intrinsic)this.solutions.grow();
            this.solveForCalibration(this.w_i, calib);
            if (this.sanityCheck(calib)) continue;
            this.solutions.removeTail();
        }
    }

    private void solveForCalibration(DMatrixRMaj w, Intrinsic calib) {
        if (this.zeroSkew) {
            calib.skew = 0.0;
            calib.fy = Math.sqrt(w.get(1, 1));
            calib.fx = this.knownAspect ? calib.fy / this.aspectRatio : Math.sqrt(w.get(0, 0));
        } else if (this.knownAspect) {
            calib.fy = Math.sqrt(w.get(1, 1));
            calib.fx = calib.fy / this.aspectRatio;
            calib.skew = w.get(0, 1) / calib.fy;
        } else {
            calib.fy = Math.sqrt(w.get(1, 1));
            calib.skew = w.get(0, 1) / calib.fy;
            calib.fx = Math.sqrt(w.get(0, 0) - calib.skew * calib.skew);
        }
    }

    boolean sanityCheck(Intrinsic calib) {
        if (UtilEjml.isUncountable((double)calib.fx)) {
            return false;
        }
        if (UtilEjml.isUncountable((double)calib.fy)) {
            return false;
        }
        if (UtilEjml.isUncountable((double)calib.skew)) {
            return false;
        }
        if (calib.fx < 0.0) {
            return false;
        }
        return !(calib.fy < 0.0);
    }

    void constructMatrix(DMatrixRMaj L) {
        L.reshape(this.cameras.size * this.eqs, 10);
        double RR = this.aspectRatio * this.aspectRatio;
        int index = 0;
        for (int i = 0; i < this.cameras.size; ++i) {
            SelfCalibrationBase.Projective P = (SelfCalibrationBase.Projective)this.cameras.get(i);
            DMatrix3x3 A = P.A;
            DMatrix3 B = P.a;
            L.data[index++] = A.a11 * A.a31;
            L.data[index++] = A.a12 * A.a31 + A.a11 * A.a32;
            L.data[index++] = A.a13 * A.a31 + A.a11 * A.a33;
            L.data[index++] = B.a1 * A.a31 + A.a11 * B.a3;
            L.data[index++] = A.a12 * A.a32;
            L.data[index++] = A.a13 * A.a32 + A.a12 * A.a33;
            L.data[index++] = B.a1 * A.a32 + A.a12 * B.a3;
            L.data[index++] = A.a13 * A.a33;
            L.data[index++] = B.a1 * A.a33 + A.a13 * B.a3;
            L.data[index++] = B.a1 * B.a3;
            L.data[index++] = A.a21 * A.a31;
            L.data[index++] = A.a22 * A.a31 + A.a21 * A.a32;
            L.data[index++] = A.a23 * A.a31 + A.a21 * A.a33;
            L.data[index++] = B.a2 * A.a31 + A.a21 * B.a3;
            L.data[index++] = A.a22 * A.a32;
            L.data[index++] = A.a23 * A.a32 + A.a22 * A.a33;
            L.data[index++] = B.a2 * A.a32 + A.a22 * B.a3;
            L.data[index++] = A.a23 * A.a33;
            L.data[index++] = B.a2 * A.a33 + A.a23 * B.a3;
            L.data[index++] = B.a2 * B.a3;
            if (this.zeroSkew) {
                L.data[index++] = A.a11 * A.a21;
                L.data[index++] = A.a12 * A.a21 + A.a11 * A.a22;
                L.data[index++] = A.a13 * A.a21 + A.a11 * A.a23;
                L.data[index++] = B.a1 * A.a21 + A.a11 * B.a2;
                L.data[index++] = A.a12 * A.a22;
                L.data[index++] = A.a13 * A.a22 + A.a12 * A.a23;
                L.data[index++] = B.a1 * A.a22 + A.a12 * B.a2;
                L.data[index++] = A.a13 * A.a23;
                L.data[index++] = B.a1 * A.a23 + A.a13 * B.a2;
                L.data[index++] = B.a1 * B.a2;
            }
            if (!this.knownAspect) continue;
            L.data[index++] = A.a11 * A.a11 * RR - A.a21 * A.a21;
            L.data[index++] = 2.0 * (A.a11 * A.a12 * RR - A.a21 * A.a22);
            L.data[index++] = 2.0 * (A.a11 * A.a13 * RR - A.a21 * A.a23);
            L.data[index++] = 2.0 * (A.a11 * B.a1 * RR - A.a21 * B.a2);
            L.data[index++] = A.a12 * A.a12 * RR - A.a22 * A.a22;
            L.data[index++] = 2.0 * (A.a12 * A.a13 * RR - A.a22 * A.a23);
            L.data[index++] = 2.0 * (A.a12 * B.a1 * RR - A.a22 * B.a2);
            L.data[index++] = A.a13 * A.a13 * RR - A.a23 * A.a23;
            L.data[index++] = 2.0 * (A.a13 * B.a1 * RR - A.a23 * B.a2);
            L.data[index++] = B.a1 * B.a1 * RR - B.a2 * B.a2;
        }
    }

    public FastAccess<Intrinsic> getIntrinsics() {
        return this.solutions;
    }

    public DMatrix3 getPlaneAtInfinity() {
        return this.decomposeADQ.getP();
    }

    public DMatrix4x4 getQ() {
        return this.Q;
    }

    public SingularValueDecomposition_F64<DMatrixRMaj> getSvd() {
        return this.svd;
    }

    public DecomposeAbsoluteDualQuadratic getDecomposeADQ() {
        return this.decomposeADQ;
    }

    public boolean isKnownAspect() {
        return this.knownAspect;
    }

    public boolean isZeroSkew() {
        return this.zeroSkew;
    }

    public double getSingularThreshold() {
        return this.singularThreshold;
    }

    public void setSingularThreshold(double singularThreshold) {
        this.singularThreshold = singularThreshold;
    }

    public static class Intrinsic {
        public double fx;
        public double fy;
        public double skew;

        public void copyTo(CameraPinhole pinhole) {
            pinhole.fx = this.fx;
            pinhole.fy = this.fy;
            pinhole.skew = this.skew;
            pinhole.cx = 0.0;
            pinhole.cy = 0.0;
        }
    }
}

