/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.Triangulate2ViewsMetricH;
import boofcv.alg.geo.PositiveDepthConstraintCheckH;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.se.Se3_F64;
import java.util.List;

public class SelectBestStereoTransformH {
    PositiveDepthConstraintCheckH depthCheck;
    int totalPassing;

    public SelectBestStereoTransformH(Triangulate2ViewsMetricH triangulate) {
        this.depthCheck = new PositiveDepthConstraintCheckH(triangulate);
    }

    public SelectBestStereoTransformH() {
        this(FactoryMultiView.triangulate2ViewMetricH(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC)));
    }

    public void select(List<Se3_F64> candidatesAtoB, List<AssociatedPair> observations, Se3_F64 model) {
        Se3_F64 bestModel = null;
        int bestCount = -1;
        for (int i = 0; i < candidatesAtoB.size(); ++i) {
            Se3_F64 s = candidatesAtoB.get(i);
            int count = 0;
            for (int pairIdx = 0; pairIdx < observations.size(); ++pairIdx) {
                AssociatedPair p = observations.get(pairIdx);
                if (!this.depthCheck.checkConstraint(p.p1, p.p2, s)) continue;
                ++count;
            }
            if (count <= bestCount) continue;
            bestCount = count;
            bestModel = s;
        }
        this.totalPassing = bestCount;
        model.setTo(bestModel);
    }

    public int getTotalPassing() {
        return this.totalPassing;
    }
}

