/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.alg.geo.robust.DistanceFromModelViews;
import boofcv.alg.geo.robust.ModelGeneratorViews;
import boofcv.alg.geo.robust.ModelMatcherViews;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.ElevateViewInfo;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;

public class LeastMedianOfSquaresProjective<Model, Point>
extends LeastMedianOfSquares<Model, Point>
implements ModelMatcherViews<Model, Point, ElevateViewInfo> {
    private final DistanceFromModelViews<Model, Point, ElevateViewInfo> modelDistance;
    private final ModelGeneratorViews<Model, Point, ElevateViewInfo> modelGenerator;

    public LeastMedianOfSquaresProjective(long randSeed, int totalCycles, double maxMedianError, double inlierFraction, ModelManager<Model> modelManager, ModelGeneratorViews<Model, Point, ElevateViewInfo> generator, DistanceFromModelViews<Model, Point, ElevateViewInfo> errorMetric) {
        super(randSeed, totalCycles, maxMedianError, inlierFraction, modelManager, errorMetric.getPointType());
        this.setModel(() -> generator, () -> errorMetric);
        this.modelDistance = errorMetric;
        this.modelGenerator = generator;
        BoofMiscOps.checkTrue((this.modelDistance.getNumberOfViews() == this.modelGenerator.getNumberOfViews() ? 1 : 0) != 0);
    }

    @Override
    public void setView(int view, ElevateViewInfo info) {
        this.modelDistance.setView(view, info);
        this.modelGenerator.setView(view, info);
    }

    @Override
    public int getNumberOfViews() {
        return this.modelDistance.getNumberOfViews();
    }
}

