/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.struct.geo.AssociatedPair;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.homography.UtilHomography_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ejml.data.DMatrixRMaj;

public class DistanceHomographySq
implements DistanceFromModel<Homography2D_F64, AssociatedPair> {
    Homography2D_F64 model;
    Point2D_F64 expected = new Point2D_F64();

    public void setModel(DMatrixRMaj H) {
        if (this.model == null) {
            this.model = new Homography2D_F64();
        }
        UtilHomography_F64.convert((DMatrixRMaj)H, (Homography2D_F64)this.model);
    }

    public void setModel(Homography2D_F64 model) {
        this.model = model;
    }

    public double distance(AssociatedPair pt) {
        HomographyPointOps_F64.transform((Homography2D_F64)this.model, (Point2D_F64)pt.p1, (Point2D_F64)this.expected);
        return this.expected.distance2((GeoTuple2D_F64)pt.p2);
    }

    public void distances(List<AssociatedPair> points, double[] distance) {
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair p = points.get(i);
            HomographyPointOps_F64.transform((Homography2D_F64)this.model, (Point2D_F64)p.p1, (Point2D_F64)this.expected);
            distance[i] = this.expected.distance2((GeoTuple2D_F64)p.p2);
        }
    }

    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    public Class<Homography2D_F64> getModelType() {
        return Homography2D_F64.class;
    }
}

