/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.Zhang99CalibrationMatrixFromHomographies;
import boofcv.alg.geo.calibration.Zhang99ComputeTargetHomography;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class ScoreCalibrationGeometricDiversity {
    Zhang99ComputeTargetHomography computeHomography;
    Zhang99CalibrationMatrixFromHomographies computeCalib;
    List<DMatrixRMaj> homographies = new ArrayList<DMatrixRMaj>();
    double score = 0.0;

    public ScoreCalibrationGeometricDiversity(boolean assumeZeroSkew, List<Point2D_F64> worldPoints) {
        this.computeCalib = new Zhang99CalibrationMatrixFromHomographies(assumeZeroSkew);
        this.computeHomography = new Zhang99ComputeTargetHomography();
        this.computeHomography.setWorldPoints(worldPoints);
    }

    public void addObservations(CalibrationObservation observations) {
        if (observations.size() <= 4) {
            return;
        }
        if (!this.computeHomography.computeHomography(observations)) {
            System.err.println("Failed to compute homography");
            return;
        }
        this.homographies.add(this.computeHomography.getHomography().copy());
    }

    public void computeScore() {
        try {
            this.computeCalib.process(this.homographies);
            double[] values = this.computeCalib.getSolverNull().getSingularValues();
            Arrays.sort(values, 0, 3);
            this.score = Math.min(1.0, values[1] / values[2] / 0.2);
        }
        catch (RuntimeException e) {
            this.score = 0.0;
        }
    }

    public double getScore() {
        return this.score;
    }
}

