/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.geo.RectifyFillType;
import boofcv.alg.geo.impl.ImplRectifyImageOps_F32;
import boofcv.alg.geo.impl.ImplRectifyImageOps_F64;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.alg.geo.rectify.RectifyFundamental;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageDimension;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class RectifyImageOps {
    public static RectifyCalibrated createCalibrated() {
        return new RectifyCalibrated();
    }

    public static RectifyFundamental createUncalibrated() {
        return new RectifyFundamental();
    }

    public static void adjustView(RectifyFillType approach, CameraPinholeBrown paramLeft, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, DMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        switch (approach) {
            case NONE: {
                break;
            }
            case ALL_INSIDE_LEFT: {
                RectifyImageOps.allInsideLeft(paramLeft, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
                break;
            }
            case FULL_VIEW_LEFT: {
                RectifyImageOps.fullViewLeft(paramLeft, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
            }
        }
    }

    public static void fullViewLeft(CameraPinholeBrown paramLeft, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, DMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        ImplRectifyImageOps_F64.fullViewLeft(paramLeft, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
    }

    public static void fullViewLeft(CameraPinholeBrown paramLeft, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight, FMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        ImplRectifyImageOps_F32.fullViewLeft(paramLeft, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
    }

    public static void fullViewLeft(int imageWidth, int imageHeight, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight) {
        ImplRectifyImageOps_F64.fullViewLeft(imageWidth, imageHeight, rectifyLeft, rectifyRight);
    }

    public static void fullViewLeft(int imageWidth, int imageHeight, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight) {
        ImplRectifyImageOps_F32.fullViewLeft(imageWidth, imageHeight, rectifyLeft, rectifyRight);
    }

    public static void allInsideLeft(CameraPinholeBrown paramLeft, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, DMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        ImplRectifyImageOps_F64.allInsideLeft(paramLeft, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
    }

    public static void allInsideLeft(CameraPinholeBrown paramLeft, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight, FMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        ImplRectifyImageOps_F32.allInsideLeft(paramLeft, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
    }

    public static void allInsideLeft(int imageWidth, int imageHeight, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight) {
        ImplRectifyImageOps_F64.allInsideLeft(imageWidth, imageHeight, rectifyLeft, rectifyRight);
    }

    public static void allInsideLeft(int imageWidth, int imageHeight, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight) {
        ImplRectifyImageOps_F32.allInsideLeft(imageWidth, imageHeight, rectifyLeft, rectifyRight);
    }

    public static Point2Transform2_F64 transformRectToPixel(CameraPinholeBrown param, DMatrixRMaj rectify) {
        return ImplRectifyImageOps_F64.transformRectToPixel(param, rectify);
    }

    public static Point2Transform2_F32 transformRectToPixel(CameraPinholeBrown param, FMatrixRMaj rectify) {
        return ImplRectifyImageOps_F32.transformRectToPixel(param, rectify);
    }

    public static Point2Transform2_F64 transformPixelToRect(CameraPinholeBrown param, DMatrixRMaj rectify) {
        return ImplRectifyImageOps_F64.transformPixelToRect(param, rectify);
    }

    public static Point2Transform2_F32 transformPixelToRect(CameraPinholeBrown param, FMatrixRMaj rectify) {
        return ImplRectifyImageOps_F32.transformPixelToRect(param, rectify);
    }

    public static Point2Transform2_F64 transformPixelToRectNorm(CameraPinholeBrown param, DMatrixRMaj rectify, DMatrixRMaj rectifyK) {
        return ImplRectifyImageOps_F64.transformPixelToRectNorm(param, rectify, rectifyK);
    }

    public static Point2Transform2_F32 transformPixelToRectNorm(CameraPinholeBrown param, FMatrixRMaj rectify, FMatrixRMaj rectifyK) {
        return ImplRectifyImageOps_F32.transformPixelToRectNorm(param, rectify, rectifyK);
    }

    public static void applyMask(GrayF32 disparity, GrayU8 mask, int radius) {
        if (disparity.isSubimage() || mask.isSubimage()) {
            throw new RuntimeException("Input is subimage. Currently not support but no reason why it can't be. Ask for it");
        }
        int N = disparity.width * disparity.height;
        for (int i = 0; i < N; ++i) {
            if (mask.data[i] != 0) continue;
            disparity.data[i] = 255.0f;
        }
        if (radius > 0) {
            int r;
            for (int y = r = radius; y < mask.height - r - 1; ++y) {
                int indexMsk = y * mask.stride + r;
                int x = r;
                while (x < mask.width - r - 1) {
                    int deltaX = mask.data[indexMsk] - mask.data[indexMsk + 1];
                    int deltaY = mask.data[indexMsk] - mask.data[indexMsk + mask.stride];
                    if (deltaX != 0 || deltaY != 0) {
                        if (deltaX < 0) {
                            deltaX = 0;
                        }
                        if (deltaY < 0) {
                            deltaY = 0;
                        }
                        for (int i = -r; i <= r; ++i) {
                            for (int j = -r; j <= r; ++j) {
                                disparity.set(deltaX + x + j, deltaY + y + i, 255.0f);
                            }
                        }
                    }
                    ++x;
                    ++indexMsk;
                }
            }
        }
    }

    public static void applyMask(GrayU8 disparity, GrayU8 mask, int radius) {
        if (disparity.isSubimage() || mask.isSubimage()) {
            throw new RuntimeException("Input is subimage. Currently not support but no reason why it can't be. Ask for it");
        }
        int N = disparity.width * disparity.height;
        for (int i = 0; i < N; ++i) {
            if (mask.data[i] != 0) continue;
            disparity.data[i] = -1;
        }
        if (radius > 0) {
            int r;
            for (int y = r = radius; y < mask.height - r - 1; ++y) {
                int indexMsk = y * mask.stride + r;
                int x = r;
                while (x < mask.width - r - 1) {
                    int deltaX = mask.data[indexMsk] - mask.data[indexMsk + 1];
                    int deltaY = mask.data[indexMsk] - mask.data[indexMsk + mask.stride];
                    if (deltaX != 0 || deltaY != 0) {
                        if (deltaX < 0) {
                            deltaX = 0;
                        }
                        if (deltaY < 0) {
                            deltaY = 0;
                        }
                        for (int i = -r; i <= r; ++i) {
                            for (int j = -r; j <= r; ++j) {
                                disparity.set(deltaX + x + j, deltaY + y + i, 255);
                            }
                        }
                    }
                    ++x;
                    ++indexMsk;
                }
            }
        }
    }
}

