/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.alg.distort.spherical.EquirectangularDistortBase_F64;
import georegression.misc.GrlConstants;

public class CylinderToEquirectangular_F64
extends EquirectangularDistortBase_F64 {
    public void configure(int width, int height, double vfov) {
        this.declareVectors(width, height);
        double r = Math.tan(vfov / 2.0);
        for (int pixelY = 0; pixelY < height; ++pixelY) {
            double z = 2.0 * r * (double)pixelY / (double)(height - 1) - r;
            for (int pixelX = 0; pixelX < width; ++pixelX) {
                double theta = GrlConstants.PI2 * (double)pixelX / (double)width - GrlConstants.PI;
                double x = Math.cos(theta);
                double y = Math.sin(theta);
                this.vectors[pixelY * width + pixelX].setTo(x, y, z);
            }
        }
    }

    public CylinderToEquirectangular_F64 copyConcurrent() {
        CylinderToEquirectangular_F64 out = new CylinderToEquirectangular_F64();
        out.setConcurrent(this);
        return out;
    }
}

