/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.kanbra;

import boofcv.alg.distort.kanbra.KannalaBrandtUtils_F64;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraKannalaBrandt;
import boofcv.struct.distort.Point2Transform3_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.RootFinderType;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.UtilEjml;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrix2x2;
import org.ejml.dense.fixed.CommonOps_DDF2;
import org.ejml.dense.fixed.MatrixFeatures_DDF2;
import org.jetbrains.annotations.Nullable;

public class KannalaBrandtPtoS_F64
implements Point2Transform3_F64,
VerbosePrint {
    public double realNumberTol = UtilEjml.TEST_F64;
    public final ConfigConverge converge = new ConfigConverge(1.0E-6, 1.0E-6, 20);
    protected final CameraKannalaBrandt model;
    PinholePtoN_F64 pinholePtoN = new PinholePtoN_F64();
    Point2D_F64 norm = new Point2D_F64();
    public PolynomialRoots rootFinder;
    private final Polynomial polynomial = new Polynomial(5);
    double updatedTheta;
    double updatedphi;
    DMatrix2x2 jacobian = new DMatrix2x2();
    DMatrix2x2 jacobianInv = new DMatrix2x2();
    @Nullable
    PrintStream verbose;

    public KannalaBrandtPtoS_F64(CameraKannalaBrandt model) {
        BoofMiscOps.checkTrue((model.radialTrig.length == 0 || model.radialTrig.length == 4 ? 1 : 0) != 0);
        this.model = new CameraKannalaBrandt(model);
        this.pinholePtoN.setK(model);
        int numCoef = 1 + model.symmetric.length * 2;
        this.rootFinder = PolynomialOps.createRootFinder((int)numCoef, (RootFinderType)RootFinderType.EVD);
        this.polynomial.resize(numCoef);
    }

    public void compute(double x, double y, Point3D_F64 out) {
        this.pinholePtoN.compute(x, y, this.norm);
        double r = this.norm.norm();
        double phi = Math.atan2(this.norm.y, this.norm.x);
        double theta = this.computeTheta(r);
        if (this.model.isAsymmetricModel()) {
            this.newtonsMethodUpdateThetaphi(theta, phi, r);
            phi = this.updatedphi;
            theta = this.updatedTheta;
        }
        if (theta == Double.MAX_VALUE) {
            out.setTo(0.0, 0.0, 0.0);
            return;
        }
        double sintheta = Math.sin(theta);
        out.x = sintheta * Math.cos(phi);
        out.y = sintheta * Math.sin(phi);
        out.z = Math.cos(theta);
    }

    double computeTheta(double r) {
        Arrays.fill(this.polynomial.c, 0.0);
        this.polynomial.c[0] = -r;
        for (int i = 0; i < this.model.symmetric.length; ++i) {
            this.polynomial.c[i * 2 + 1] = this.model.symmetric[i];
        }
        if (!this.rootFinder.process(this.polynomial)) {
            return Double.MAX_VALUE;
        }
        double theta = Double.MAX_VALUE;
        List roots = this.rootFinder.getRoots();
        for (int i = 0; i < roots.size(); ++i) {
            Complex_F64 root = (Complex_F64)roots.get(i);
            if (!(Math.abs(root.imaginary) <= this.realNumberTol) || !(theta > root.real) || !(root.real > -this.realNumberTol)) continue;
            theta = root.real;
        }
        return Math.max(0.0, theta);
    }

    protected void newtonsMethodUpdateThetaphi(double theta, double phi, double r) {
        double previousError = Double.MAX_VALUE;
        this.updatedTheta = theta;
        this.updatedphi = phi;
        double updatedR = r;
        for (int iteration = 0; iteration < this.converge.maxIterations; ++iteration) {
            double cosphi = Math.cos(this.updatedphi);
            double sinphi = Math.sin(this.updatedphi);
            double disRad = KannalaBrandtUtils_F64.polynomial(this.model.radial, this.updatedTheta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi);
            double disTan = KannalaBrandtUtils_F64.polynomial(this.model.tangent, this.updatedTheta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi);
            double dx = (updatedR + disRad) * cosphi - disTan * sinphi;
            double dy = (updatedR + disRad) * sinphi + disTan * cosphi;
            double error = this.norm.distance(dx, dy);
            if (this.verbose != null) {
                this.verbose.printf("[%3d] error=%.2e theta=%.4f phi=%.4f\n", iteration, error, this.updatedTheta, this.updatedphi);
            }
            if (error > previousError) {
                if (this.verbose == null) break;
                this.verbose.println("converged: error > previousError");
                break;
            }
            if (Math.abs(error) <= this.converge.ftol) {
                if (this.verbose == null) break;
                this.verbose.println("converged: ftol");
                break;
            }
            if (Math.abs(error - previousError) / Math.max(error, previousError) <= this.converge.gtol) {
                if (this.verbose == null) break;
                this.verbose.println("converged: gtol");
                break;
            }
            previousError = error;
            theta = this.updatedTheta;
            phi = this.updatedphi;
            this.jacobianOfDistorted(theta, cosphi, sinphi, this.jacobian);
            if (!CommonOps_DDF2.invert((DMatrix2x2)this.jacobian, (DMatrix2x2)this.jacobianInv) || MatrixFeatures_DDF2.hasUncountable((DMatrix2x2)this.jacobianInv)) {
                if (this.verbose == null) break;
                this.verbose.println("Bad matrix inverse");
                break;
            }
            dx = this.norm.x - dx;
            dy = this.norm.y - dy;
            double deltaTheta = this.jacobianInv.a11 * dx + this.jacobianInv.a12 * dy;
            double deltaphi = this.jacobianInv.a21 * dx + this.jacobianInv.a22 * dy;
            this.updatedTheta = theta + deltaTheta;
            this.updatedphi = phi + deltaphi;
            updatedR = KannalaBrandtUtils_F64.polynomial(this.model.symmetric, this.updatedTheta);
        }
    }

    protected void jacobianOfDistorted(double theta, double cosphi, double sinphi, DMatrix2x2 gradient) {
        double sym = KannalaBrandtUtils_F64.polynomial(this.model.symmetric, theta);
        double sym_dtheta = KannalaBrandtUtils_F64.polynomialDerivative(this.model.symmetric, theta);
        double deltaR = KannalaBrandtUtils_F64.polynomial(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi);
        double deltaR_dtheta = KannalaBrandtUtils_F64.polynomialDerivative(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi);
        double deltaR_dphi = KannalaBrandtUtils_F64.polynomial(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrigDerivative(this.model.radialTrig, cosphi, sinphi);
        double deltaT = KannalaBrandtUtils_F64.polynomial(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi);
        double deltaT_dtheta = KannalaBrandtUtils_F64.polynomialDerivative(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi);
        double deltaT_dphi = KannalaBrandtUtils_F64.polynomial(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrigDerivative(this.model.tangentTrig, cosphi, sinphi);
        gradient.a11 = (sym_dtheta + deltaR_dtheta) * cosphi - deltaT_dtheta * sinphi;
        gradient.a12 = -sym * sinphi + deltaR_dphi * cosphi - deltaR * sinphi - deltaT_dphi * sinphi - deltaT * cosphi;
        gradient.a21 = (sym_dtheta + deltaR_dtheta) * sinphi + deltaT_dtheta * cosphi;
        gradient.a22 = sym * cosphi + deltaR_dphi * sinphi + deltaR * cosphi + deltaT_dphi * cosphi - deltaT * sinphi;
    }

    public Point2Transform3_F64 copyConcurrent() {
        return new KannalaBrandtPtoS_F64(this.model);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }
}

