/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.brown;

import boofcv.alg.distort.brown.RadialTangential_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;
import org.jetbrains.annotations.Nullable;

public class AddBrownPtoN_F32
implements Point2Transform2_F32 {
    protected RadialTangential_F32 params;
    private float a11;
    private float a12;
    private float a13;
    private float a22;
    private float a23;

    public AddBrownPtoN_F32 setK(double fx, double fy, double skew, double cx, double cy) {
        this.a11 = (float)(1.0 / fx);
        this.a12 = (float)(-skew / (fx * fy));
        this.a13 = (float)((skew * cy - cx * fy) / (fx * fy));
        this.a22 = (float)(1.0 / fy);
        this.a23 = (float)(-cy / fy);
        return this;
    }

    public AddBrownPtoN_F32 setDistortion(@Nullable double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F32(radial, t1, t2);
        return this;
    }

    public void compute(float x, float y, Point2D_F32 out) {
        float r2;
        float sum = 0.0f;
        float[] radial = this.params.radial;
        float t1 = this.params.t1;
        float t2 = this.params.t2;
        out.x = this.a11 * x + this.a12 * y + this.a13;
        out.y = this.a22 * y + this.a23;
        float ri2 = r2 = out.x * out.x + out.y * out.y;
        for (int i = 0; i < radial.length; ++i) {
            sum += radial[i] * ri2;
            ri2 *= r2;
        }
        float tx = 2.0f * t1 * out.x * out.y + t2 * (r2 + 2.0f * out.x * out.x);
        float ty = t1 * (r2 + 2.0f * out.y * out.y) + 2.0f * t2 * out.x * out.y;
        out.x = out.x * (1.0f + sum) + tx;
        out.y = out.y * (1.0f + sum) + ty;
    }

    public AddBrownPtoN_F32 copyConcurrent() {
        AddBrownPtoN_F32 ret = new AddBrownPtoN_F32();
        ret.a11 = this.a11;
        ret.a12 = this.a12;
        ret.a13 = this.a13;
        ret.a22 = this.a22;
        ret.a23 = this.a23;
        ret.params = new RadialTangential_F32(this.params);
        return ret;
    }
}

