/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.alg.geo.h.AdjustHomographyMatrix;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedPair3D;
import boofcv.struct.geo.AssociatedPairConic;
import georegression.geometry.UtilCurves_F64;
import georegression.struct.curve.ConicGeneral_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import java.util.Objects;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.jetbrains.annotations.Nullable;

public class HomographyDirectLinearTransform {
    protected DMatrixRMaj A = new DMatrixRMaj(1, 9);
    protected SolveNullSpace<DMatrixRMaj> solverNullspace = new SolveNullSpaceSvd_DDRM();
    protected NormalizationPoint2D N1 = new NormalizationPoint2D();
    protected NormalizationPoint2D N2 = new NormalizationPoint2D();
    private AdjustHomographyMatrix adjust = new AdjustHomographyMatrix();
    boolean normalize;
    private boolean shouldNormalize;
    private boolean exhaustiveConics = false;
    private final DMatrix3x3 C1 = new DMatrix3x3();
    private final DMatrix3x3 V1 = new DMatrix3x3();
    private final DMatrix3x3 C1_inv = new DMatrix3x3();
    private final DMatrix3x3 V1_inv = new DMatrix3x3();
    private final DMatrix3x3 C2 = new DMatrix3x3();
    private final DMatrix3x3 V2 = new DMatrix3x3();
    private final DMatrix3x3 C2_inv = new DMatrix3x3();
    private final DMatrix3x3 V2_inv = new DMatrix3x3();
    private final DMatrix3x3 L = new DMatrix3x3();
    private final DMatrix3x3 R = new DMatrix3x3();

    public HomographyDirectLinearTransform(boolean normalizeInput) {
        this.normalize = normalizeInput;
    }

    public boolean process(List<AssociatedPair> points, DMatrixRMaj foundH) {
        return this.process(points, null, null, foundH);
    }

    public boolean process(@Nullable List<AssociatedPair> points2D, @Nullable List<AssociatedPair3D> points3D, @Nullable List<AssociatedPairConic> conics, DMatrixRMaj foundH) {
        int num2D = points2D != null ? points2D.size() : 0;
        int num3D = points3D != null ? points3D.size() : 0;
        int numConic = conics != null ? conics.size() : 0;
        int numRows = this.computeTotalRows(num2D, num3D, numConic);
        this.shouldNormalize = false;
        if (this.shouldNormalize) {
            LowLevelMultiViewOps.computeNormalization(Objects.requireNonNull(points2D), this.N1, this.N2);
        }
        this.A.reshape(numRows, 9);
        this.A.zero();
        int rows = 0;
        if (points2D != null) {
            rows = this.addPoints2D(points2D, this.A, rows);
        }
        if (points3D != null) {
            rows = this.addPoints3D(points3D, this.A, rows);
        }
        if (conics != null) {
            this.addConics(conics, this.A, rows);
        }
        if (this.computeH(this.A, foundH)) {
            return false;
        }
        if (this.shouldNormalize) {
            HomographyDirectLinearTransform.undoNormalizationH(foundH, this.N1, this.N2);
        }
        if (points2D != null) {
            this.adjust.adjust(foundH, points2D.get(0));
        }
        return true;
    }

    protected boolean computeH(DMatrixRMaj A, DMatrixRMaj H) {
        if (!this.solverNullspace.process((Matrix)A.copy(), 1, (Matrix)H)) {
            return true;
        }
        H.numRows = 3;
        H.numCols = 3;
        return false;
    }

    public static void undoNormalizationH(DMatrixRMaj M, NormalizationPoint2D N1, NormalizationPoint2D N2) {
        SimpleMatrix a = SimpleMatrix.wrap((Matrix)M);
        SimpleMatrix b = SimpleMatrix.wrap((Matrix)N1.matrix(null));
        SimpleMatrix c_inv = SimpleMatrix.wrap((Matrix)N2.matrixInv(null));
        SimpleMatrix result = (SimpleMatrix)((SimpleMatrix)c_inv.mult((SimpleBase)a)).mult((SimpleBase)b);
        M.setTo((DMatrixD1)result.getDDRM());
    }

    private void adjustPoint(AssociatedPair pair, Point2D_F64 a1, Point2D_F64 a2) {
        if (this.shouldNormalize) {
            this.N1.apply(pair.p1, a1);
            this.N2.apply(pair.p2, a2);
        } else {
            a1.setTo(pair.p1);
            a2.setTo(pair.p2);
        }
    }

    int computeTotalRows(int num2D, int num3D, int numConic) {
        return 2 * num2D + 2 * num3D + 9 * numConic;
    }

    private void adjustPoint(AssociatedPair3D pair, Point3D_F64 a1, Point3D_F64 a2) {
        if (this.shouldNormalize) {
            this.N1.apply(pair.p1, a1);
            this.N2.apply(pair.p2, a2);
        } else {
            a1.setTo(pair.p1);
            a2.setTo(pair.p2);
        }
    }

    protected int addPoints2D(List<AssociatedPair> points, DMatrixRMaj A, int rows) {
        Point2D_F64 f = new Point2D_F64();
        Point2D_F64 s = new Point2D_F64();
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair p = points.get(i);
            this.adjustPoint(p, f, s);
            A.set(rows, 3, -f.x);
            A.set(rows, 4, -f.y);
            A.set(rows, 5, -1.0);
            A.set(rows, 6, s.y * f.x);
            A.set(rows, 7, s.y * f.y);
            A.set(rows, 8, s.y);
            A.set(++rows, 0, f.x);
            A.set(rows, 1, f.y);
            A.set(rows, 2, 1.0);
            A.set(rows, 6, -s.x * f.x);
            A.set(rows, 7, -s.x * f.y);
            A.set(rows, 8, -s.x);
            ++rows;
        }
        return rows;
    }

    protected int addPoints3D(List<AssociatedPair3D> points, DMatrixRMaj A, int rows) {
        Point3D_F64 f = new Point3D_F64();
        Point3D_F64 s = new Point3D_F64();
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair3D p = points.get(i);
            this.adjustPoint(p, f, s);
            A.set(rows, 3, -s.z * f.x);
            A.set(rows, 4, -s.z * f.y);
            A.set(rows, 5, -s.z * f.z);
            A.set(rows, 6, s.y * f.x);
            A.set(rows, 7, s.y * f.y);
            A.set(rows, 8, s.y * f.z);
            A.set(++rows, 0, s.z * f.x);
            A.set(rows, 1, s.z * f.y);
            A.set(rows, 2, s.z * f.z);
            A.set(rows, 6, -s.x * f.x);
            A.set(rows, 7, -s.x * f.y);
            A.set(rows, 8, -s.x * f.z);
            ++rows;
        }
        return rows;
    }

    protected int addConics(List<AssociatedPairConic> points, DMatrixRMaj A, int rows) {
        if (this.exhaustiveConics) {
            for (int i = 0; i < points.size(); ++i) {
                for (int j = i + 1; j < points.size(); ++j) {
                    rows = this.addConicPairConstraints(points.get(i), points.get(j), A, rows);
                }
            }
        } else {
            for (int i = 1; i < points.size(); ++i) {
                rows = this.addConicPairConstraints(points.get(i - 1), points.get(i), A, rows);
            }
            int N = points.size();
            rows = this.addConicPairConstraints(points.get(0), points.get(N - 1), A, rows);
        }
        return rows;
    }

    protected int addConicPairConstraints(AssociatedPairConic a, AssociatedPairConic b, DMatrixRMaj A, int rowA) {
        UtilCurves_F64.convert((ConicGeneral_F64)a.p1, (DMatrix3x3)this.C1);
        UtilCurves_F64.convert((ConicGeneral_F64)a.p2, (DMatrix3x3)this.V1);
        CommonOps_DDF3.invert((DMatrix3x3)this.C1, (DMatrix3x3)this.C1_inv);
        CommonOps_DDF3.invert((DMatrix3x3)this.V1, (DMatrix3x3)this.V1_inv);
        UtilCurves_F64.convert((ConicGeneral_F64)b.p1, (DMatrix3x3)this.C2);
        UtilCurves_F64.convert((ConicGeneral_F64)b.p2, (DMatrix3x3)this.V2);
        CommonOps_DDF3.invert((DMatrix3x3)this.C2, (DMatrix3x3)this.C2_inv);
        CommonOps_DDF3.invert((DMatrix3x3)this.V2, (DMatrix3x3)this.V2_inv);
        CommonOps_DDF3.mult((DMatrix3x3)this.V1_inv, (DMatrix3x3)this.V2, (DMatrix3x3)this.L);
        CommonOps_DDF3.mult((DMatrix3x3)this.C1_inv, (DMatrix3x3)this.C2, (DMatrix3x3)this.R);
        int idxA = rowA * 9;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                for (int i = 0; i < 3; ++i) {
                    int n = idxA + 3 * i + col;
                    A.data[n] = A.data[n] + this.L.get(row, i);
                    int n2 = idxA + 3 * row + i;
                    A.data[n2] = A.data[n2] - this.R.get(i, col);
                }
                idxA += 9;
            }
        }
        return rowA + 9;
    }

    public SolveNullSpace<DMatrixRMaj> getSolverNullspace() {
        return this.solverNullspace;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public boolean isExhaustiveConics() {
        return this.exhaustiveConics;
    }

    public void setExhaustiveConics(boolean exhaustiveConics) {
        this.exhaustiveConics = exhaustiveConics;
    }
}

