/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.alg.geo.bundle.cameras.BundleUniversalOmni;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.RadialDistortionEstimateLinear;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraUniversalOmni;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class Zhang99CameraUniversalOmni
implements Zhang99Camera {
    boolean assumeZeroSkew;
    boolean includeTangential;
    public boolean fixedMirror;
    double mirror;
    private final RadialDistortionEstimateLinear computeRadial;

    public Zhang99CameraUniversalOmni(List<Point2D_F64> layout, boolean assumeZeroSkew, boolean includeTangential, int numRadial, double mirror) {
        this(layout, assumeZeroSkew, includeTangential, numRadial);
        this.fixedMirror = true;
        this.mirror = mirror;
    }

    public Zhang99CameraUniversalOmni(List<Point2D_F64> layout, boolean assumeZeroSkew, boolean includeTangential, int numRadial) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.includeTangential = includeTangential;
        this.fixedMirror = false;
        this.computeRadial = new RadialDistortionEstimateLinear(layout, numRadial);
    }

    @Override
    public BundleAdjustmentCamera initializeCamera(DMatrixRMaj K, List<DMatrixRMaj> homographies, List<CalibrationObservation> observations) {
        this.computeRadial.process(K, homographies, observations);
        double[] radial = this.computeRadial.getParameters();
        BundleUniversalOmni cam = new BundleUniversalOmni(this.assumeZeroSkew, radial.length, this.includeTangential, this.fixedMirror);
        System.arraycopy(radial, 0, cam.radial, 0, radial.length);
        cam.setK(K);
        cam.mirrorOffset = this.fixedMirror ? this.mirror : 0.0;
        cam.t2 = 0.0;
        cam.t1 = 0.0;
        return cam;
    }

    @Override
    public CameraModel getCameraModel(BundleAdjustmentCamera bundleCam) {
        BundleUniversalOmni cam = (BundleUniversalOmni)bundleCam;
        CameraUniversalOmni out = new CameraUniversalOmni(cam.radial.length);
        cam.convert(out);
        return out;
    }
}

