/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.cloud;

import boofcv.struct.Point3dRgbI_F32;
import boofcv.struct.Point3dRgbI_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;

public interface PointCloudWriter {
    public void initialize(int var1, boolean var2);

    public void add(double var1, double var3, double var5, int var7);

    public static PointCloudWriter wrapF32(final DogArray<Point3D_F32> cloud) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reserve(size);
                cloud.reset();
            }

            @Override
            public void add(double x, double y, double z, int rgb) {
                ((Point3D_F32)cloud.grow()).setTo((float)x, (float)y, (float)z);
            }
        };
    }

    public static PointCloudWriter wrapF64(final DogArray<Point3D_F64> cloud) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reserve(size);
                cloud.reset();
            }

            @Override
            public void add(double x, double y, double z, int rgb) {
                ((Point3D_F64)cloud.grow()).setTo(x, y, z);
            }
        };
    }

    public static PointCloudWriter wrapF32RGB(final DogArray<Point3dRgbI_F32> cloud) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reserve(size);
                cloud.reset();
            }

            @Override
            public void add(double x, double y, double z, int rgb) {
                ((Point3dRgbI_F32)cloud.grow()).setTo((float)x, (float)y, (float)z, rgb);
            }
        };
    }

    public static PointCloudWriter wrapF64RGB(final DogArray<Point3dRgbI_F64> cloud) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reset();
            }

            @Override
            public void add(double x, double y, double z, int rgb) {
                ((Point3dRgbI_F64)cloud.grow()).setTo(x, y, z, rgb);
            }
        };
    }

    public static class CloudArraysF32
    implements PointCloudWriter {
        public DogArray_F32 cloudXyz = new DogArray_F32();
        public DogArray_I32 cloudRgb = new DogArray_I32();

        @Override
        public void initialize(int size, boolean hasColor) {
            this.cloudRgb.reset();
            this.cloudXyz.reset();
            this.cloudRgb.reserve(size);
            this.cloudXyz.reserve(size * 3);
        }

        @Override
        public void add(double x, double y, double z, int rgb) {
            this.cloudXyz.add((float)x);
            this.cloudXyz.add((float)y);
            this.cloudXyz.add((float)z);
            this.cloudRgb.add(rgb);
        }
    }
}

