/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.geo;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.Estimate1ofTrifocalTensor;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.geo.fitting.DistanceFromModelResidual;
import boofcv.abst.geo.fitting.GenerateEpipolarMatrix;
import boofcv.abst.geo.fitting.ModelManagerEpipolarMatrix;
import boofcv.alg.geo.f.FundamentalResidualSampson;
import boofcv.alg.geo.pose.PnPDistanceReprojectionSq;
import boofcv.alg.geo.robust.DistanceFundamentalGeometric;
import boofcv.alg.geo.robust.DistanceHomographyCalibratedSq;
import boofcv.alg.geo.robust.DistanceHomographySq;
import boofcv.alg.geo.robust.DistanceMultiView_EssentialSampson;
import boofcv.alg.geo.robust.DistanceSe3SymmetricSq;
import boofcv.alg.geo.robust.DistanceTrifocalReprojectionSq;
import boofcv.alg.geo.robust.DistanceTrifocalTransferSq;
import boofcv.alg.geo.robust.GenerateHomographyLinear;
import boofcv.alg.geo.robust.GenerateTrifocalTensor;
import boofcv.alg.geo.robust.LeastMedianOfSquaresMultiView;
import boofcv.alg.geo.robust.ManagerTrifocalTensor;
import boofcv.alg.geo.robust.MmmvSe3ToEssential;
import boofcv.alg.geo.robust.ModelMatcherMultiview;
import boofcv.alg.geo.robust.RansacMultiView;
import boofcv.alg.geo.robust.Se3FromEssentialGenerator;
import boofcv.factory.geo.ConfigEssential;
import boofcv.factory.geo.ConfigFundamental;
import boofcv.factory.geo.ConfigHomography;
import boofcv.factory.geo.ConfigLMedS;
import boofcv.factory.geo.ConfigPnP;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.ConfigTrifocalError;
import boofcv.factory.geo.EstimatorToGenerator;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.TrifocalTensor;
import georegression.fitting.homography.ModelManagerHomography2D_F64;
import georegression.fitting.se.ModelManagerSe3_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.se.Se3_F64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ejml.data.DMatrixRMaj;

public class FactoryMultiViewRobust {
    public static ModelMatcherMultiview<Se3_F64, Point2D3D> pnpLMedS(@Nullable ConfigPnP configPnP, @Nonnull ConfigLMedS configLMedS) {
        if (configPnP == null) {
            configPnP = new ConfigPnP();
        }
        configPnP.checkValidity();
        configLMedS.checkValidity();
        Estimate1ofPnP estimatorPnP = FactoryMultiView.pnp_1(configPnP.which, configPnP.epnpIterations, configPnP.numResolve);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>(estimatorPnP);
        LeastMedianOfSquaresMultiView<Se3_F64, Point2D3D> lmeds = new LeastMedianOfSquaresMultiView<Se3_F64, Point2D3D>(configLMedS.randSeed, configLMedS.totalCycles, (ModelManager<Se3_F64>)manager, (ModelGenerator<Se3_F64, Point2D3D>)generator, distance);
        lmeds.setErrorFraction(configLMedS.errorFraction);
        return lmeds;
    }

    public static ModelMatcherMultiview<Se3_F64, Point2D3D> pnpRansac(@Nullable ConfigPnP pnp, @Nonnull ConfigRansac ransac) {
        if (pnp == null) {
            pnp = new ConfigPnP();
        }
        pnp.checkValidity();
        ransac.checkValidity();
        Estimate1ofPnP estimatorPnP = FactoryMultiView.pnp_1(pnp.which, pnp.epnpIterations, pnp.numResolve);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>(estimatorPnP);
        double threshold = ransac.inlierThreshold * ransac.inlierThreshold;
        return new RansacMultiView<Se3_F64, Point2D3D>(ransac.randSeed, (ModelManager<Se3_F64>)manager, (ModelGenerator<Se3_F64, Point2D3D>)generator, distance, ransac.iterations, threshold);
    }

    public static ModelMatcherMultiview<Se3_F64, AssociatedPair> baselineLMedS(@Nullable ConfigEssential essential, @Nonnull ConfigLMedS lmeds) {
        if (essential == null) {
            essential = new ConfigEssential();
        } else {
            essential.checkValidity();
        }
        Estimate1ofEpipolar epipolar = FactoryMultiView.essential_1(essential.which, essential.numResolve);
        Triangulate2ViewsMetric triangulate = FactoryMultiView.triangulate2ViewMetric(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        Se3FromEssentialGenerator generateEpipolarMotion = new Se3FromEssentialGenerator(epipolar, triangulate);
        DistanceSe3SymmetricSq distanceSe3 = new DistanceSe3SymmetricSq(triangulate);
        LeastMedianOfSquaresMultiView<Se3_F64, AssociatedPair> config = new LeastMedianOfSquaresMultiView<Se3_F64, AssociatedPair>(lmeds.randSeed, lmeds.totalCycles, (ModelManager<Se3_F64>)manager, generateEpipolarMotion, distanceSe3);
        config.setErrorFraction(lmeds.errorFraction);
        return config;
    }

    public static ModelMatcher<DMatrixRMaj, AssociatedPair> fundamentalLMedS(@Nonnull ConfigFundamental fundamental, @Nonnull ConfigLMedS lmeds) {
        Object errorMetric;
        fundamental.checkValidity();
        lmeds.checkValidity();
        ModelManagerEpipolarMatrix managerF = new ModelManagerEpipolarMatrix();
        Estimate1ofEpipolar estimateF = FactoryMultiView.fundamental_1(fundamental.which, fundamental.numResolve);
        GenerateEpipolarMatrix generateF = new GenerateEpipolarMatrix(estimateF);
        switch (fundamental.errorModel) {
            case SAMPSON: {
                errorMetric = new DistanceFromModelResidual<DMatrixRMaj, AssociatedPair>(new FundamentalResidualSampson());
                break;
            }
            case GEOMETRIC: {
                errorMetric = new DistanceFundamentalGeometric();
                break;
            }
            default: {
                throw new RuntimeException("Unknown");
            }
        }
        LeastMedianOfSquares config = new LeastMedianOfSquares(lmeds.randSeed, lmeds.totalCycles, (ModelManager)managerF, (ModelGenerator)generateF, (DistanceFromModel)errorMetric);
        config.setErrorFraction(lmeds.errorFraction);
        return config;
    }

    public static ModelMatcherMultiview<Se3_F64, AssociatedPair> baselineRansac(@Nullable ConfigEssential essential, @Nonnull ConfigRansac ransac) {
        if (essential == null) {
            essential = new ConfigEssential();
        } else {
            essential.checkValidity();
        }
        ransac.checkValidity();
        if (essential.errorModel != ConfigEssential.ErrorModel.GEOMETRIC) {
            throw new RuntimeException("Error model has to be Euclidean");
        }
        Estimate1ofEpipolar epipolar = FactoryMultiView.essential_1(essential.which, essential.numResolve);
        Triangulate2ViewsMetric triangulate = FactoryMultiView.triangulate2ViewMetric(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        Se3FromEssentialGenerator generateEpipolarMotion = new Se3FromEssentialGenerator(epipolar, triangulate);
        DistanceSe3SymmetricSq distanceSe3 = new DistanceSe3SymmetricSq(triangulate);
        double ransacTOL = ransac.inlierThreshold * ransac.inlierThreshold * 2.0;
        return new RansacMultiView<Se3_F64, AssociatedPair>(ransac.randSeed, (ModelManager<Se3_F64>)manager, generateEpipolarMotion, distanceSe3, ransac.iterations, ransacTOL);
    }

    public static ModelMatcherMultiview<DMatrixRMaj, AssociatedPair> essentialRansac(@Nullable ConfigEssential essential, @Nonnull ConfigRansac ransac) {
        if (essential == null) {
            essential = new ConfigEssential();
        } else {
            essential.checkValidity();
        }
        ransac.checkValidity();
        if (essential.errorModel == ConfigEssential.ErrorModel.GEOMETRIC) {
            return new MmmvSe3ToEssential(FactoryMultiViewRobust.baselineRansac(essential, ransac));
        }
        ModelManagerEpipolarMatrix managerE = new ModelManagerEpipolarMatrix();
        Estimate1ofEpipolar estimateF = FactoryMultiView.essential_1(essential.which, essential.numResolve);
        GenerateEpipolarMatrix generateE = new GenerateEpipolarMatrix(estimateF);
        DistanceMultiView_EssentialSampson errorMetric = new DistanceMultiView_EssentialSampson();
        double ransacTOL = ransac.inlierThreshold * ransac.inlierThreshold;
        return new RansacMultiView<DMatrixRMaj, AssociatedPair>(ransac.randSeed, managerE, generateE, errorMetric, ransac.iterations, ransacTOL);
    }

    public static ModelMatcher<DMatrixRMaj, AssociatedPair> fundamentalRansac(@Nonnull ConfigFundamental fundamental, @Nonnull ConfigRansac ransac) {
        Object errorMetric;
        fundamental.checkValidity();
        ransac.checkValidity();
        ModelManagerEpipolarMatrix managerF = new ModelManagerEpipolarMatrix();
        Estimate1ofEpipolar estimateF = FactoryMultiView.fundamental_1(fundamental.which, fundamental.numResolve);
        GenerateEpipolarMatrix generateF = new GenerateEpipolarMatrix(estimateF);
        switch (fundamental.errorModel) {
            case SAMPSON: {
                errorMetric = new DistanceFromModelResidual<DMatrixRMaj, AssociatedPair>(new FundamentalResidualSampson());
                break;
            }
            case GEOMETRIC: {
                errorMetric = new DistanceFundamentalGeometric();
                break;
            }
            default: {
                throw new RuntimeException("Unknown");
            }
        }
        double ransacTOL = ransac.inlierThreshold * ransac.inlierThreshold;
        return new Ransac(ransac.randSeed, (ModelManager)managerF, (ModelGenerator)generateF, (DistanceFromModel)errorMetric, ransac.iterations, ransacTOL);
    }

    public static LeastMedianOfSquares<Homography2D_F64, AssociatedPair> homographyLMedS(@Nullable ConfigHomography homography, @Nonnull ConfigLMedS configLMedS) {
        if (homography == null) {
            homography = new ConfigHomography();
        }
        ModelManagerHomography2D_F64 manager = new ModelManagerHomography2D_F64();
        GenerateHomographyLinear modelFitter = new GenerateHomographyLinear(homography.normalize);
        DistanceHomographySq distance = new DistanceHomographySq();
        LeastMedianOfSquares lmeds = new LeastMedianOfSquares(configLMedS.randSeed, configLMedS.totalCycles, (ModelManager)manager, (ModelGenerator)modelFitter, (DistanceFromModel)distance);
        lmeds.setErrorFraction(configLMedS.errorFraction);
        return lmeds;
    }

    public static Ransac<Homography2D_F64, AssociatedPair> homographyRansac(@Nullable ConfigHomography homography, @Nonnull ConfigRansac ransac) {
        if (homography == null) {
            homography = new ConfigHomography();
        }
        ModelManagerHomography2D_F64 manager = new ModelManagerHomography2D_F64();
        GenerateHomographyLinear modelFitter = new GenerateHomographyLinear(homography.normalize);
        DistanceHomographySq distance = new DistanceHomographySq();
        double ransacTol = ransac.inlierThreshold * ransac.inlierThreshold;
        return new Ransac(ransac.randSeed, (ModelManager)manager, (ModelGenerator)modelFitter, (DistanceFromModel)distance, ransac.iterations, ransacTol);
    }

    public static RansacMultiView<Homography2D_F64, AssociatedPair> homographyCalibratedRansac(@Nonnull ConfigRansac ransac) {
        ModelManagerHomography2D_F64 manager = new ModelManagerHomography2D_F64();
        GenerateHomographyLinear modelFitter = new GenerateHomographyLinear(false);
        DistanceHomographyCalibratedSq distance = new DistanceHomographyCalibratedSq();
        double ransacTol = ransac.inlierThreshold * ransac.inlierThreshold;
        return new RansacMultiView<Homography2D_F64, AssociatedPair>(ransac.randSeed, (ModelManager<Homography2D_F64>)manager, modelFitter, distance, ransac.iterations, ransacTol);
    }

    public static Ransac<TrifocalTensor, AssociatedTriple> trifocalRansac(@Nullable ConfigTrifocal trifocal, @Nullable ConfigTrifocalError error, @Nonnull ConfigRansac ransac) {
        Object distance;
        double ransacTol;
        if (trifocal == null) {
            trifocal = new ConfigTrifocal();
        }
        if (error == null) {
            error = new ConfigTrifocalError();
        }
        trifocal.checkValidity();
        switch (error.model) {
            case REPROJECTION: {
                ransacTol = 3.0 * ransac.inlierThreshold * ransac.inlierThreshold;
                distance = new DistanceTrifocalReprojectionSq();
                break;
            }
            case REPROJECTION_REFINE: {
                ransacTol = 3.0 * ransac.inlierThreshold * ransac.inlierThreshold;
                distance = new DistanceTrifocalReprojectionSq(error.converge.gtol, error.converge.maxIterations);
                break;
            }
            case POINT_TRANSFER: {
                ransacTol = 2.0 * ransac.inlierThreshold * ransac.inlierThreshold;
                distance = new DistanceTrifocalTransferSq();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown error model " + (Object)((Object)error.model));
            }
        }
        Estimate1ofTrifocalTensor estimator = FactoryMultiView.trifocal_1(trifocal);
        ManagerTrifocalTensor manager = new ManagerTrifocalTensor();
        GenerateTrifocalTensor generator = new GenerateTrifocalTensor(estimator);
        return new Ransac(ransac.randSeed, (ModelManager)manager, (ModelGenerator)generator, (DistanceFromModel)distance, ransac.iterations, ransacTol);
    }
}

