/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.pose.Relinearlize;
import boofcv.alg.geo.pose.UtilLepetitEPnP;
import georegression.fitting.MotionTransformPoint;
import georegression.fitting.se.FitSpecialEuclideanOps_F64;
import georegression.geometry.UtilPoint3D_F64;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.dense.row.mult.MatrixVectorMult_DDRM;
import org.ejml.interfaces.SolveNullSpace;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class PnPLepetitEPnP {
    private SolveNullSpace<DMatrixRMaj> solverNull = new SolveNullSpaceSvd_DDRM();
    DMatrixRMaj nullspace = new DMatrixRMaj(1, 1);
    private SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((int)12, (int)12, (boolean)false, (boolean)true, (boolean)false);
    private LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.leastSquares((int)6, (int)4);
    private LinearSolverDense<DMatrixRMaj> solverPinv = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
    protected DMatrixRMaj alphas = new DMatrixRMaj(1, 1);
    private DMatrixRMaj M = new DMatrixRMaj(12, 12);
    private DMatrixRMaj MM = new DMatrixRMaj(12, 12);
    protected DMatrixRMaj L_full = new DMatrixRMaj(6, 10);
    private DMatrixRMaj L = new DMatrixRMaj(6, 6);
    protected DMatrixRMaj y = new DMatrixRMaj(6, 1);
    private DMatrixRMaj x = new DMatrixRMaj(6, 1);
    protected int numControl;
    protected List<Point3D_F64>[] nullPts = new ArrayList[4];
    protected FastQueue<Point3D_F64> controlWorldPts = new FastQueue(4, Point3D_F64::new);
    private List<double[]> solutions = new ArrayList<double[]>();
    protected FastQueue<Point3D_F64> solutionPts = new FastQueue(4, Point3D_F64::new);
    private MotionTransformPoint<Se3_F64, Point3D_F64> motionFit = FitSpecialEuclideanOps_F64.fitPoints3D();
    private Point3D_F64 meanWorldPts = new Point3D_F64();
    private int numIterations;
    private double magicNumber;
    Relinearlize relinearizeBeta = new Relinearlize();
    private List<Point3D_F64> tempPts0 = new ArrayList<Point3D_F64>();
    DMatrixRMaj A_temp = new DMatrixRMaj(1, 1);
    DMatrixRMaj v_temp = new DMatrixRMaj(3, 1);
    DMatrixRMaj w_temp = new DMatrixRMaj(1, 1);

    public PnPLepetitEPnP() {
        this(0.1);
    }

    public PnPLepetitEPnP(double magicNumber) {
        this.magicNumber = magicNumber;
        if (this.motionFit.getMinimumPoints() > 4) {
            throw new IllegalArgumentException("Crap");
        }
        for (int i = 0; i < 4; ++i) {
            this.tempPts0.add(new Point3D_F64());
            this.nullPts[i] = new ArrayList<Point3D_F64>();
            this.solutions.add(new double[4]);
            for (int j = 0; j < 4; ++j) {
                this.nullPts[i].add(new Point3D_F64());
            }
        }
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void process(List<Point3D_F64> worldPts, List<Point2D_F64> observed, Se3_F64 solutionModel) {
        if (worldPts.size() < 4) {
            throw new IllegalArgumentException("Must provide at least 4 points");
        }
        if (worldPts.size() != observed.size()) {
            throw new IllegalArgumentException("Must have the same number of observations and world points");
        }
        this.selectWorldControlPoints(worldPts, this.controlWorldPts);
        this.computeBarycentricCoordinates(this.controlWorldPts, this.alphas, worldPts);
        PnPLepetitEPnP.constructM(observed, this.alphas, this.M);
        this.extractNullPoints(this.M);
        if (this.numControl == 4) {
            this.L_full.reshape(6, 10);
            this.y.reshape(6, 1);
            UtilLepetitEPnP.constraintMatrix6x10(this.L_full, this.y, this.controlWorldPts, this.nullPts);
            this.estimateCase1(this.solutions.get(0));
            this.estimateCase2(this.solutions.get(1));
            this.estimateCase3(this.solutions.get(2));
            if (worldPts.size() == 4) {
                this.estimateCase4(this.solutions.get(3));
            }
        } else {
            this.L_full.reshape(3, 6);
            this.y.reshape(3, 1);
            UtilLepetitEPnP.constraintMatrix3x6(this.L_full, this.y, this.controlWorldPts, this.nullPts);
            this.estimateCase1(this.solutions.get(0));
            this.estimateCase2(this.solutions.get(1));
            if (worldPts.size() == 3) {
                this.estimateCase3_planar(this.solutions.get(2));
            }
        }
        this.computeResultFromBest(solutionModel);
    }

    private void computeResultFromBest(Se3_F64 solutionModel) {
        double bestScore = Double.MAX_VALUE;
        int bestSolution = -1;
        for (int i = 0; i < this.numControl; ++i) {
            double score = this.score(this.solutions.get(i));
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestSolution = i;
        }
        double[] solution = this.solutions.get(bestSolution);
        if (this.numIterations > 0) {
            this.gaussNewton(solution);
        }
        UtilLepetitEPnP.computeCameraControl(solution, this.nullPts, this.solutionPts, this.numControl);
        this.motionFit.process(this.controlWorldPts.toList(), this.solutionPts.toList());
        solutionModel.set((Se3_F64)this.motionFit.getTransformSrcToDst());
    }

    private double score(double[] betas) {
        UtilLepetitEPnP.computeCameraControl(betas, this.nullPts, this.solutionPts, this.numControl);
        int index = 0;
        double score = 0.0;
        for (int i = 0; i < this.numControl; ++i) {
            Point3D_F64 si = (Point3D_F64)this.solutionPts.get(i);
            Point3D_F64 wi = (Point3D_F64)this.controlWorldPts.get(i);
            int j = i + 1;
            while (j < this.numControl) {
                double ds = si.distance((GeoTuple_F64)((Point3D_F64)this.solutionPts.get(j)));
                double dw = wi.distance((GeoTuple_F64)((Point3D_F64)this.controlWorldPts.get(j)));
                score += (ds - dw) * (ds - dw);
                ++j;
                ++index;
            }
        }
        return score;
    }

    public void selectWorldControlPoints(List<Point3D_F64> worldPts, FastQueue<Point3D_F64> controlWorldPts) {
        UtilPoint3D_F64.mean(worldPts, (Point3D_F64)this.meanWorldPts);
        double c11 = 0.0;
        double c12 = 0.0;
        double c13 = 0.0;
        double c22 = 0.0;
        double c23 = 0.0;
        double c33 = 0.0;
        int N = worldPts.size();
        for (int i = 0; i < N; ++i) {
            Point3D_F64 p = worldPts.get(i);
            double dx = p.x - this.meanWorldPts.x;
            double dy = p.y - this.meanWorldPts.y;
            double dz = p.z - this.meanWorldPts.z;
            c11 += dx * dx;
            c12 += dx * dy;
            c13 += dx * dz;
            c22 += dy * dy;
            c23 += dy * dz;
            c33 += dz * dz;
        }
        DMatrixRMaj covar = new DMatrixRMaj(3, 3, true, new double[]{c11 /= (double)N, c12 /= (double)N, c13 /= (double)N, c12, c22 /= (double)N, c23 /= (double)N, c13, c23, c33 /= (double)N});
        this.svd.decompose((Matrix)covar);
        double[] singularValues = this.svd.getSingularValues();
        DMatrixRMaj V = (DMatrixRMaj)this.svd.getV(null, false);
        SingularOps_DDRM.descendingOrder(null, (boolean)false, (double[])singularValues, (int)3, (DMatrixRMaj)V, (boolean)false);
        this.numControl = singularValues[0] < singularValues[2] * 1.0E13 ? 4 : 3;
        controlWorldPts.reset();
        for (int i = 0; i < this.numControl - 1; ++i) {
            double m = Math.sqrt(singularValues[1]) * this.magicNumber;
            double vx = V.unsafe_get(0, i) * m;
            double vy = V.unsafe_get(1, i) * m;
            double vz = V.unsafe_get(2, i) * m;
            ((Point3D_F64)controlWorldPts.grow()).set(this.meanWorldPts.x + vx, this.meanWorldPts.y + vy, this.meanWorldPts.z + vz);
        }
        ((Point3D_F64)controlWorldPts.grow()).set(this.meanWorldPts.x, this.meanWorldPts.y, this.meanWorldPts.z);
    }

    protected void computeBarycentricCoordinates(FastQueue<Point3D_F64> controlWorldPts, DMatrixRMaj alphas, List<Point3D_F64> worldPts) {
        int i;
        alphas.reshape(worldPts.size(), this.numControl, false);
        this.v_temp.reshape(3, 1);
        this.A_temp.reshape(3, this.numControl - 1);
        for (i = 0; i < this.numControl - 1; ++i) {
            Point3D_F64 c = (Point3D_F64)controlWorldPts.get(i);
            this.A_temp.set(0, i, c.x - this.meanWorldPts.x);
            this.A_temp.set(1, i, c.y - this.meanWorldPts.y);
            this.A_temp.set(2, i, c.z - this.meanWorldPts.z);
        }
        this.solverPinv.setA((Matrix)this.A_temp);
        this.A_temp.reshape(this.A_temp.numCols, this.A_temp.numRows);
        this.solverPinv.invert((Matrix)this.A_temp);
        this.w_temp.reshape(this.numControl - 1, 1);
        for (i = 0; i < worldPts.size(); ++i) {
            Point3D_F64 p = worldPts.get(i);
            this.v_temp.data[0] = p.x - this.meanWorldPts.x;
            this.v_temp.data[1] = p.y - this.meanWorldPts.y;
            this.v_temp.data[2] = p.z - this.meanWorldPts.z;
            MatrixVectorMult_DDRM.mult((DMatrix1Row)this.A_temp, (DMatrixD1)this.v_temp, (DMatrixD1)this.w_temp);
            int rowIndex = alphas.numCols * i;
            for (int j = 0; j < this.numControl - 1; ++j) {
                alphas.data[rowIndex++] = this.w_temp.data[j];
            }
            alphas.data[rowIndex] = this.numControl == 4 ? 1.0 - this.w_temp.data[0] - this.w_temp.data[1] - this.w_temp.data[2] : 1.0 - this.w_temp.data[0] - this.w_temp.data[1];
        }
    }

    protected static void constructM(List<Point2D_F64> obsPts, DMatrixRMaj alphas, DMatrixRMaj M) {
        int N = obsPts.size();
        M.reshape(3 * alphas.numCols, 2 * N, false);
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p2 = obsPts.get(i);
            int row = i * 2;
            for (int j = 0; j < alphas.numCols; ++j) {
                int col = j * 3;
                double alpha = alphas.unsafe_get(i, j);
                M.unsafe_set(col, row, alpha);
                M.unsafe_set(col + 1, row, 0.0);
                M.unsafe_set(col + 2, row, -alpha * p2.x);
                M.unsafe_set(col, row + 1, 0.0);
                M.unsafe_set(col + 1, row + 1, alpha);
                M.unsafe_set(col + 2, row + 1, -alpha * p2.y);
            }
        }
    }

    protected void extractNullPoints(DMatrixRMaj M) {
        this.MM.reshape(M.numRows, M.numRows, false);
        CommonOps_DDRM.multTransB((DMatrix1Row)M, (DMatrix1Row)M, (DMatrix1Row)this.MM);
        if (!this.solverNull.process((Matrix)this.MM, this.numControl, (Matrix)this.nullspace)) {
            throw new IllegalArgumentException("SVD failed?!?!");
        }
        for (int i = 0; i < this.numControl; ++i) {
            int column = this.numControl - i - 1;
            for (int j = 0; j < this.numControl; ++j) {
                Point3D_F64 p = this.nullPts[i].get(j);
                p.x = this.nullspace.get(j * 3 + 0, column);
                p.y = this.nullspace.get(j * 3 + 1, column);
                p.z = this.nullspace.get(j * 3 + 2, column);
            }
        }
    }

    protected double matchScale(List<Point3D_F64> nullPts, FastQueue<Point3D_F64> controlWorldPts) {
        Point3D_F64 meanNull = UtilPoint3D_F64.mean(nullPts, (int)this.numControl, null);
        Point3D_F64 meanWorld = UtilPoint3D_F64.mean((List)controlWorldPts.toList(), (int)this.numControl, null);
        double top = 0.0;
        double bottom = 0.0;
        for (int i = 0; i < this.numControl; ++i) {
            Point3D_F64 wi = (Point3D_F64)controlWorldPts.get(i);
            Point3D_F64 ni = nullPts.get(i);
            double dwx = wi.x - meanWorld.x;
            double dwy = wi.y - meanWorld.y;
            double dwz = wi.z - meanWorld.z;
            double dnx = ni.x - meanNull.x;
            double dny = ni.y - meanNull.y;
            double dnz = ni.z - meanNull.z;
            double n2 = dnx * dnx + dny * dny + dnz * dnz;
            double w2 = dwx * dwx + dwy * dwy + dwz * dwz;
            top += w2;
            bottom += n2;
        }
        return Math.sqrt(top / bottom);
    }

    private double adjustBetaSign(double beta, List<Point3D_F64> nullPts) {
        if (beta == 0.0) {
            return 0.0;
        }
        int N = this.alphas.numRows;
        int positiveCount = 0;
        for (int i = 0; i < N; ++i) {
            double z = 0.0;
            for (int j = 0; j < this.numControl; ++j) {
                Point3D_F64 c = nullPts.get(j);
                z += this.alphas.get(i, j) * c.z;
            }
            if (!(z > 0.0)) continue;
            ++positiveCount;
        }
        if (positiveCount < N / 2) {
            beta *= -1.0;
        }
        return beta;
    }

    private void refine(double[] betas) {
        for (int i = 0; i < this.numControl; ++i) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            for (int j = 0; j < this.numControl; ++j) {
                Point3D_F64 p = this.nullPts[j].get(i);
                x += betas[j] * p.x;
                y += betas[j] * p.y;
                z += betas[j] * p.z;
            }
            this.tempPts0.get(i).set(x, y, z);
        }
        double adj = this.matchScale(this.tempPts0, this.controlWorldPts);
        adj = this.adjustBetaSign(adj, this.tempPts0);
        int i = 0;
        while (i < 4) {
            int n = i++;
            betas[n] = betas[n] * adj;
        }
    }

    protected void estimateCase1(double[] betas) {
        betas[0] = this.matchScale(this.nullPts[0], this.controlWorldPts);
        betas[0] = this.adjustBetaSign(betas[0], this.nullPts[0]);
        betas[1] = 0.0;
        betas[2] = 0.0;
        betas[3] = 0.0;
    }

    protected void estimateCase2(double[] betas) {
        this.x.reshape(3, 1, false);
        if (this.numControl == 4) {
            this.L.reshape(6, 3, false);
            UtilLepetitEPnP.constraintMatrix6x3(this.L_full, this.L);
        } else {
            this.L.reshape(3, 3, false);
            UtilLepetitEPnP.constraintMatrix3x3(this.L_full, this.L);
        }
        if (!this.solver.setA((Matrix)this.L)) {
            throw new RuntimeException("Oh crap");
        }
        this.solver.solve((Matrix)this.y, (Matrix)this.x);
        betas[0] = Math.sqrt(Math.abs(this.x.get(0)));
        betas[1] = Math.sqrt(Math.abs(this.x.get(2)));
        betas[1] = betas[1] * (Math.signum(this.x.get(0)) * Math.signum(this.x.get(1)));
        betas[2] = 0.0;
        betas[3] = 0.0;
        this.refine(betas);
    }

    protected void estimateCase3(double[] betas) {
        Arrays.fill(betas, 0.0);
        this.x.reshape(6, 1, false);
        this.L.reshape(6, 6, false);
        UtilLepetitEPnP.constraintMatrix6x6(this.L_full, this.L);
        if (!this.solver.setA((Matrix)this.L)) {
            throw new RuntimeException("Oh crap");
        }
        this.solver.solve((Matrix)this.y, (Matrix)this.x);
        betas[0] = Math.sqrt(Math.abs(this.x.get(0)));
        betas[1] = Math.sqrt(Math.abs(this.x.get(3)));
        betas[2] = Math.sqrt(Math.abs(this.x.get(5)));
        betas[1] = betas[1] * (Math.signum(this.x.get(0)) * Math.signum(this.x.get(1)));
        betas[2] = betas[2] * (Math.signum(this.x.get(0)) * Math.signum(this.x.get(2)));
        betas[3] = 0.0;
        this.refine(betas);
    }

    protected void estimateCase3_planar(double[] betas) {
        this.relinearizeBeta.setNumberControl(3);
        this.relinearizeBeta.process(this.L_full, this.y, betas);
        this.refine(betas);
    }

    protected void estimateCase4(double[] betas) {
        this.relinearizeBeta.setNumberControl(4);
        this.relinearizeBeta.process(this.L_full, this.y, betas);
        this.refine(betas);
    }

    private void gaussNewton(double[] betas) {
        this.A_temp.reshape(this.L_full.numRows, this.numControl);
        this.v_temp.reshape(this.L_full.numRows, 1);
        this.x.reshape(this.numControl, 1, false);
        if (this.numControl == 4) {
            for (int i = 0; i < this.numIterations; ++i) {
                UtilLepetitEPnP.jacobian_Control4(this.L_full, betas, this.A_temp);
                UtilLepetitEPnP.residuals_Control4(this.L_full, this.y, betas, this.v_temp.data);
                if (!this.solver.setA((Matrix)this.A_temp)) {
                    return;
                }
                this.solver.solve((Matrix)this.v_temp, (Matrix)this.x);
                for (int j = 0; j < this.numControl; ++j) {
                    int n = j;
                    betas[n] = betas[n] - this.x.data[j];
                }
            }
        } else {
            for (int i = 0; i < this.numIterations; ++i) {
                UtilLepetitEPnP.jacobian_Control3(this.L_full, betas, this.A_temp);
                UtilLepetitEPnP.residuals_Control3(this.L_full, this.y, betas, this.v_temp.data);
                if (!this.solver.setA((Matrix)this.A_temp)) {
                    return;
                }
                this.solver.solve((Matrix)this.v_temp, (Matrix)this.x);
                for (int j = 0; j < this.numControl; ++j) {
                    int n = j;
                    betas[n] = betas[n] - this.x.data[j];
                }
            }
        }
    }

    public int getMinPoints() {
        return 5;
    }
}

