/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.pose.P3PLineDistance;
import boofcv.alg.geo.pose.PointDistance3;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.Complex_F64;

public class P3PGrunert
implements P3PLineDistance {
    private PolynomialRoots rootFinder;
    private Polynomial poly = new Polynomial(5);
    private FastQueue<PointDistance3> solutions = new FastQueue(4, PointDistance3::new);

    public P3PGrunert(PolynomialRoots rootFinder) {
        this.rootFinder = rootFinder;
    }

    @Override
    public boolean process(Point2D_F64 obs1, Point2D_F64 obs2, Point2D_F64 obs3, double length23, double length13, double length12) {
        double cos12 = P3PGrunert.computeCosine(obs1, obs2);
        double cos13 = P3PGrunert.computeCosine(obs1, obs3);
        double cos23 = P3PGrunert.computeCosine(obs2, obs3);
        double a = length23;
        double b = length13;
        double c = length12;
        double a2_div_b2 = a / b * (a / b);
        double c2_div_b2 = c / b * (c / b);
        double a2_m_c2_div_b2 = a2_div_b2 - c2_div_b2;
        double a2_p_c2_div_b2 = a2_div_b2 + c2_div_b2;
        this.poly.c[0] = -4.0 * a2_div_b2 * P3PGrunert.pow2(cos12) + P3PGrunert.pow2(a2_m_c2_div_b2 + 1.0);
        this.poly.c[1] = 4.0 * (-a2_m_c2_div_b2 * (1.0 + a2_m_c2_div_b2) * cos13 + 2.0 * a2_div_b2 * P3PGrunert.pow2(cos12) * cos13 - (1.0 - a2_p_c2_div_b2) * cos23 * cos12);
        this.poly.c[2] = 2.0 * (P3PGrunert.pow2(a2_m_c2_div_b2) - 1.0 + 2.0 * P3PGrunert.pow2(a2_m_c2_div_b2) * P3PGrunert.pow2(cos13) + 2.0 * (1.0 - c2_div_b2) * P3PGrunert.pow2(cos23) - 4.0 * a2_p_c2_div_b2 * cos12 * cos13 * cos23 + 2.0 * (1.0 - a2_div_b2) * P3PGrunert.pow2(cos12));
        this.poly.c[3] = 4.0 * (a2_m_c2_div_b2 * (1.0 - a2_m_c2_div_b2) * cos13 - (1.0 - a2_p_c2_div_b2) * cos23 * cos12 + 2.0 * c2_div_b2 * P3PGrunert.pow2(cos23) * cos13);
        this.poly.c[4] = -4.0 * c2_div_b2 * cos23 * cos23 + P3PGrunert.pow2(a2_m_c2_div_b2 - 1.0);
        this.solutions.reset();
        if (!this.rootFinder.process(this.poly)) {
            return false;
        }
        List roots = this.rootFinder.getRoots();
        for (Complex_F64 r : roots) {
            if (!r.isReal()) continue;
            double v = r.real;
            double u = ((-1.0 + a2_div_b2 - c2_div_b2) * v * v - 2.0 * (a2_div_b2 - c2_div_b2) * cos13 * v + 1.0 + a2_div_b2 - c2_div_b2) / (2.0 * (cos12 - v * cos23));
            PointDistance3 s = (PointDistance3)this.solutions.grow();
            s.dist1 = Math.sqrt(a * a / (u * u + v * v - 2.0 * u * v * cos23));
            s.dist2 = s.dist1 * u;
            s.dist3 = s.dist1 * v;
        }
        return this.solutions.size() != 0;
    }

    public static double pow2(double a) {
        return a * a;
    }

    public static double computeCosine(Point2D_F64 a, Point2D_F64 b) {
        double top = a.x * b.x + a.y * b.y + 1.0;
        double bottom = Math.sqrt(a.x * a.x + a.y * a.y + 1.0) * Math.sqrt(b.x * b.x + b.y * b.y + 1.0);
        return top / bottom;
    }

    @Override
    public FastQueue<PointDistance3> getSolutions() {
        return this.solutions;
    }
}

