/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.misc.ConfigConverge;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.GeoTuple4D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UtilOptimize;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.dense.row.linsol.svd.SolvePseudoInverseSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class CompatibleProjectiveHomography {
    public LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.leastSquares((int)200, (int)16);
    public SolveNullSpace<DMatrixRMaj> nullspace = new SolveNullSpaceSvd_DDRM();
    public SolvePseudoInverseSvd_DDRM solvePInv = new SolvePseudoInverseSvd_DDRM();
    private DMatrixRMaj A = new DMatrixRMaj(1, 1);
    private DMatrixRMaj B = new DMatrixRMaj(1, 1);
    private Point4D_F64 a = new Point4D_F64();
    private Point4D_F64 b = new Point4D_F64();
    private DMatrixRMaj PinvP = new DMatrixRMaj(4, 4);
    private DMatrixRMaj h = new DMatrixRMaj(1, 1);
    private DistanceWorldEuclidean distanceWorld = new DistanceWorldEuclidean();
    private DistanceReprojection distanceRepojection = new DistanceReprojection();
    public UnconstrainedLeastSquares<DMatrixRMaj> lm;
    public final ConfigConverge configConverge = new ConfigConverge(1.0E-8, 1.0E-8, 500);

    public CompatibleProjectiveHomography() {
        ConfigLevenbergMarquardt config = new ConfigLevenbergMarquardt();
        this.lm = FactoryOptimization.levenbergMarquardt((ConfigLevenbergMarquardt)config, (boolean)false);
    }

    public boolean fitPoints(List<Point4D_F64> points1, List<Point4D_F64> points2, DMatrixRMaj H) {
        if (points1.size() != points2.size()) {
            throw new IllegalArgumentException("Must have the same number in each list");
        }
        if (points1.size() < 5) {
            throw new IllegalArgumentException("At least 5 points required");
        }
        int size = points1.size();
        this.A.reshape(size * 3, 16);
        for (int i = 0; i < size; ++i) {
            int idx;
            int j;
            Point4D_F64 a = points1.get(i);
            Point4D_F64 b = points2.get(i);
            double alpha = -(a.x + a.y + a.z + a.w);
            for (j = 0; j < 3; ++j) {
                idx = 16 * (3 * i + j);
                double va = a.getIdx(j);
                for (int k = 0; k < 4; ++k) {
                    this.A.data[idx++] = va * b.x;
                    this.A.data[idx++] = va * b.y;
                    this.A.data[idx++] = va * b.z;
                    this.A.data[idx++] = va * b.w;
                }
            }
            for (j = 0; j < 3; ++j) {
                int n = idx = 16 * (3 * i + j) + 4 * j;
                this.A.data[n] = this.A.data[n] + b.x * alpha;
                int n2 = idx + 1;
                this.A.data[n2] = this.A.data[n2] + b.y * alpha;
                int n3 = idx + 2;
                this.A.data[n3] = this.A.data[n3] + b.z * alpha;
                int n4 = idx + 3;
                this.A.data[n4] = this.A.data[n4] + b.w * alpha;
            }
        }
        if (!this.nullspace.process((Matrix)this.A, 1, (Matrix)H)) {
            return false;
        }
        H.reshape(4, 4);
        return true;
    }

    public boolean fitCameras(List<DMatrixRMaj> cameras1, List<DMatrixRMaj> cameras2, DMatrixRMaj H) {
        if (cameras1.size() != cameras2.size()) {
            throw new IllegalArgumentException("Must have the same number in each list");
        }
        if (cameras1.size() < 2) {
            throw new IllegalArgumentException("At least two cameras are required");
        }
        int size = cameras1.size();
        this.A.reshape(size * 3, 4);
        this.B.reshape(size * 3, 4);
        for (int i = 0; i < size; ++i) {
            DMatrixRMaj P1 = cameras1.get(i);
            DMatrixRMaj P2 = cameras2.get(i);
            CommonOps_DDRM.insert((DMatrix)P1, (DMatrix)this.A, (int)(i * 3), (int)0);
            CommonOps_DDRM.insert((DMatrix)P2, (DMatrix)this.B, (int)(i * 3), (int)0);
        }
        if (!this.solver.setA((Matrix)this.A)) {
            return false;
        }
        H.reshape(4, 4);
        this.solver.solve((Matrix)this.B, (Matrix)H);
        return true;
    }

    public boolean fitCameraPoints(DMatrixRMaj camera1, DMatrixRMaj camera2, List<Point4D_F64> points1, List<Point4D_F64> points2, DMatrixRMaj H) {
        int i;
        if (points1.size() != points2.size()) {
            throw new IllegalArgumentException("Lists must be the same size");
        }
        if (points1.size() < 2) {
            throw new IllegalArgumentException("A minimum of two points are required");
        }
        if (!this.solvePInv.setA(camera1)) {
            return false;
        }
        if (!this.nullspace.process((Matrix)camera1, 1, (Matrix)this.h)) {
            return false;
        }
        this.solvePInv.solve(camera2, this.PinvP);
        int size = points1.size();
        this.A.reshape(size * 3, 4);
        this.B.reshape(size * 3, 1);
        int idxA = 0;
        int idxB = 0;
        for (i = 0; i < size; ++i) {
            Point4D_F64 p1 = points1.get(i);
            Point4D_F64 p2 = points2.get(i);
            GeometryMath_F64.mult((DMatrixRMaj)this.PinvP, (GeoTuple4D_F64)p2, (GeoTuple4D_F64)this.a);
            double a_sum = this.a.x + this.a.y + this.a.z + this.a.w;
            double h_sum = this.h.data[0] + this.h.data[1] + this.h.data[2] + this.h.data[3];
            double x_sum = p1.x + p1.y + p1.z + p1.w;
            for (int k = 0; k < 3; ++k) {
                double b_k = this.h.data[k] * x_sum - h_sum * p1.getIdx(k);
                double c_k = p1.getIdx(k) * a_sum - x_sum * this.a.getIdx(k);
                this.A.data[idxA++] = b_k * p2.x;
                this.A.data[idxA++] = b_k * p2.y;
                this.A.data[idxA++] = b_k * p2.z;
                this.A.data[idxA++] = b_k * p2.w;
                this.B.data[idxB++] = c_k;
            }
        }
        if (!this.solver.setA((Matrix)this.A)) {
            return false;
        }
        H.reshape(4, 1);
        this.solver.solve((Matrix)this.B, (Matrix)H);
        this.a.set(H.data[0], H.data[1], H.data[2], H.data[3]);
        H.reshape(4, 4);
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                H.data[i * 4 + j] = this.PinvP.get(i, j) + this.h.data[i] * this.a.getIdx(j);
            }
        }
        return true;
    }

    public void refineWorld(List<Point3D_F64> scene1, List<Point3D_F64> scene2, DMatrixRMaj H) {
        if (H.numCols != 4 || H.numRows != 4) {
            throw new IllegalArgumentException("Expected 4x4 matrix for H");
        }
        this.distanceWorld.scene1 = scene1;
        this.distanceWorld.scene2 = scene2;
        this.lm.setFunction((FunctionNtoM)this.distanceWorld, null);
        this.lm.initialize(H.data, 1.0E-8, 1.0E-8);
        UtilOptimize.process(this.lm, (int)this.configConverge.maxIterations);
        System.arraycopy(this.lm.getParameters(), 0, H.data, 0, 16);
        this.distanceWorld.scene1 = null;
        this.distanceWorld.scene2 = null;
    }

    public void refineReprojection(List<DMatrixRMaj> cameras1, List<Point4D_F64> scene1, List<Point4D_F64> scene2, DMatrixRMaj H) {
        if (H.numCols != 4 || H.numRows != 4) {
            throw new IllegalArgumentException("Expected 4x4 matrix for H");
        }
        if (scene1.size() != scene2.size() || scene1.size() <= 0) {
            throw new IllegalArgumentException("Lists must have equal size and be not empty");
        }
        if (cameras1.isEmpty()) {
            throw new IllegalArgumentException("Camera must not be empty");
        }
        this.distanceRepojection.cameras1 = cameras1;
        this.distanceRepojection.scene1 = scene1;
        this.distanceRepojection.scene2 = scene2;
        this.lm.setFunction((FunctionNtoM)this.distanceRepojection, null);
        this.lm.initialize(H.data, this.configConverge.ftol, this.configConverge.gtol);
        UtilOptimize.process(this.lm, (int)this.configConverge.maxIterations);
        System.arraycopy(this.lm.getParameters(), 0, H.data, 0, 16);
        this.distanceRepojection.cameras1 = null;
        this.distanceRepojection.scene1 = null;
        this.distanceRepojection.scene2 = null;
    }

    private static class DistanceReprojection
    implements FunctionNtoM {
        List<DMatrixRMaj> cameras1;
        List<Point4D_F64> scene1;
        List<Point4D_F64> scene2;
        Point4D_F64 ba = new Point4D_F64();
        DMatrixRMaj H = new DMatrixRMaj(4, 4);
        Point2D_F64 pixel1 = new Point2D_F64();
        Point2D_F64 pixel2 = new Point2D_F64();

        private DistanceReprojection() {
        }

        public void process(double[] input, double[] output) {
            this.H.data = input;
            int outputIdx = 0;
            for (int viewIdx = 0; viewIdx < this.cameras1.size(); ++viewIdx) {
                DMatrixRMaj P = this.cameras1.get(viewIdx);
                for (int pointIdx = 0; pointIdx < this.scene1.size(); ++pointIdx) {
                    Point4D_F64 a = this.scene1.get(pointIdx);
                    Point4D_F64 b = this.scene2.get(pointIdx);
                    GeometryMath_F64.mult((DMatrixRMaj)this.H, (GeoTuple4D_F64)b, (GeoTuple4D_F64)this.ba);
                    PerspectiveOps.renderPixel(P, a, this.pixel1);
                    PerspectiveOps.renderPixel(P, this.ba, this.pixel2);
                    output[outputIdx++] = this.pixel1.x - this.pixel2.x;
                    output[outputIdx++] = this.pixel1.y - this.pixel2.y;
                }
            }
        }

        public int getNumOfInputsN() {
            return 16;
        }

        public int getNumOfOutputsM() {
            return this.cameras1.size() * this.scene1.size() * 2;
        }
    }

    private static class DistanceWorldEuclidean
    implements FunctionNtoM {
        List<Point3D_F64> scene1;
        List<Point3D_F64> scene2;
        Point3D_F64 ba = new Point3D_F64();
        DMatrixRMaj H = new DMatrixRMaj(4, 4);

        private DistanceWorldEuclidean() {
        }

        public void process(double[] input, double[] output) {
            this.H.data = input;
            int idx = 0;
            for (int i = 0; i < this.scene1.size(); ++i) {
                Point3D_F64 a = this.scene1.get(i);
                Point3D_F64 b = this.scene2.get(i);
                GeometryMath_F64.mult4((DMatrixRMaj)this.H, (GeoTuple3D_F64)b, (GeoTuple3D_F64)this.ba);
                output[idx++] = a.x - this.ba.x;
                output[idx++] = a.y - this.ba.y;
                output[idx++] = a.z - this.ba.z;
            }
        }

        public int getNumOfInputsN() {
            return 16;
        }

        public int getNumOfOutputsM() {
            return this.scene1.size() * 3;
        }
    }
}

