/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.impl;

import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.LensDistortionOps_F64;
import boofcv.alg.distort.PointToPixelTransform_F64;
import boofcv.alg.distort.PointTransformHomography_F64;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.SequencePoint2Transform2_F64;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.RectangleLength2D_F64;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class ImplRectifyImageOps_F64 {
    public static void fullViewLeft(CameraPinholeBrown paramLeft, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, DMatrixRMaj rectifyK, ImageDimension rectifiedSize) {
        paramLeft = new CameraPinholeBrown(paramLeft);
        Point2Transform2_F64 tranLeft = ImplRectifyImageOps_F64.transformPixelToRect(paramLeft, rectifyLeft);
        Point2D_F64 work = new Point2D_F64();
        RectangleLength2D_F64 bound = DistortImageOps.boundBox_F64((int)paramLeft.width, (int)paramLeft.height, (PixelTransform)new PointToPixelTransform_F64(tranLeft), (Point2D_F64)work);
        double scale = Math.sqrt((double)(paramLeft.width * paramLeft.height) / (bound.width * bound.height));
        rectifiedSize.width = (int)(scale * bound.width + 0.5);
        rectifiedSize.height = (int)(scale * bound.height + 0.5);
        ImplRectifyImageOps_F64.adjustCalibrated(rectifyLeft, rectifyRight, rectifyK, bound, scale);
    }

    public static void fullViewLeft(int imageWidth, int imageHeight, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight) {
        PointTransformHomography_F64 tranLeft = new PointTransformHomography_F64(rectifyLeft);
        Point2D_F64 work = new Point2D_F64();
        RectangleLength2D_F64 bound = DistortImageOps.boundBox_F64((int)imageWidth, (int)imageHeight, (PixelTransform)new PointToPixelTransform_F64((Point2Transform2_F64)tranLeft), (Point2D_F64)work);
        double scaleX = (double)imageWidth / bound.width;
        double scaleY = (double)imageHeight / bound.height;
        double scale = Math.min(scaleX, scaleY);
        ImplRectifyImageOps_F64.adjustUncalibrated(rectifyLeft, rectifyRight, bound, scale);
    }

    public static void allInsideLeft(CameraPinholeBrown paramLeft, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, DMatrixRMaj rectifyK, ImageDimension rectifiedSize) {
        paramLeft = new CameraPinholeBrown(paramLeft);
        Point2Transform2_F64 tranLeft = ImplRectifyImageOps_F64.transformPixelToRect(paramLeft, rectifyLeft);
        Point2D_F64 work = new Point2D_F64();
        RectangleLength2D_F64 bound = LensDistortionOps_F64.boundBoxInside(paramLeft.width, paramLeft.height, (PixelTransform<Point2D_F64>)new PointToPixelTransform_F64(tranLeft), work);
        LensDistortionOps_F64.roundInside(bound);
        double scale = Math.sqrt((double)(paramLeft.width * paramLeft.height) / (bound.width * bound.height));
        rectifiedSize.width = (int)(scale * bound.width + 0.5);
        rectifiedSize.height = (int)(scale * bound.height + 0.5);
        ImplRectifyImageOps_F64.adjustCalibrated(rectifyLeft, rectifyRight, rectifyK, bound, scale);
    }

    public static void allInsideLeft(int imageWidth, int imageHeight, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight) {
        PointTransformHomography_F64 tranLeft = new PointTransformHomography_F64(rectifyLeft);
        Point2D_F64 work = new Point2D_F64();
        RectangleLength2D_F64 bound = LensDistortionOps_F64.boundBoxInside(imageWidth, imageHeight, (PixelTransform<Point2D_F64>)new PointToPixelTransform_F64((Point2Transform2_F64)tranLeft), work);
        double scaleX = (double)imageWidth / bound.width;
        double scaleY = (double)imageHeight / bound.height;
        double scale = Math.max(scaleX, scaleY);
        ImplRectifyImageOps_F64.adjustUncalibrated(rectifyLeft, rectifyRight, bound, scale);
    }

    private static void adjustCalibrated(DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, DMatrixRMaj rectifyK, RectangleLength2D_F64 bound, double scale) {
        double deltaX = -bound.x0 * scale;
        double deltaY = -bound.y0 * scale;
        SimpleMatrix A = new SimpleMatrix(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        SimpleMatrix rL = SimpleMatrix.wrap((Matrix)rectifyLeft);
        SimpleMatrix rR = SimpleMatrix.wrap((Matrix)rectifyRight);
        SimpleMatrix K = SimpleMatrix.wrap((Matrix)rectifyK);
        SimpleMatrix K_inv = (SimpleMatrix)K.invert();
        rL = (SimpleMatrix)K_inv.mult((SimpleBase)rL);
        rR = (SimpleMatrix)K_inv.mult((SimpleBase)rR);
        K = (SimpleMatrix)A.mult((SimpleBase)K);
        rectifyK.set((DMatrixD1)K.getDDRM());
        rectifyLeft.set((DMatrixD1)((SimpleMatrix)K.mult((SimpleBase)rL)).getDDRM());
        rectifyRight.set((DMatrixD1)((SimpleMatrix)K.mult((SimpleBase)rR)).getDDRM());
    }

    private static void adjustUncalibrated(DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, RectangleLength2D_F64 bound, double scale) {
        double deltaX = -bound.x0 * scale;
        double deltaY = -bound.y0 * scale;
        SimpleMatrix A = new SimpleMatrix(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        SimpleMatrix rL = SimpleMatrix.wrap((Matrix)rectifyLeft);
        SimpleMatrix rR = SimpleMatrix.wrap((Matrix)rectifyRight);
        rectifyLeft.set((DMatrixD1)((SimpleMatrix)A.mult((SimpleBase)rL)).getDDRM());
        rectifyRight.set((DMatrixD1)((SimpleMatrix)A.mult((SimpleBase)rR)).getDDRM());
    }

    public static Point2Transform2_F64 transformRectToPixel(CameraPinholeBrown param, DMatrixRMaj rectify) {
        Point2Transform2_F64 add_p_to_p = LensDistortionFactory.narrow(param).distort_F64(true, true);
        DMatrixRMaj rectifyInv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.invert((DMatrixRMaj)rectify, (DMatrixRMaj)rectifyInv);
        PointTransformHomography_F64 removeRect = new PointTransformHomography_F64(rectifyInv);
        return new SequencePoint2Transform2_F64(new Point2Transform2_F64[]{removeRect, add_p_to_p});
    }

    public static Point2Transform2_F64 transformPixelToRect(CameraPinholeBrown param, DMatrixRMaj rectify) {
        Point2Transform2_F64 remove_p_to_p = LensDistortionFactory.narrow(param).undistort_F64(true, true);
        PointTransformHomography_F64 rectifyDistort = new PointTransformHomography_F64(rectify);
        return new SequencePoint2Transform2_F64(new Point2Transform2_F64[]{remove_p_to_p, rectifyDistort});
    }

    public static Point2Transform2_F64 transformPixelToRectNorm(CameraPinholeBrown param, DMatrixRMaj rectify, DMatrixRMaj rectifyK) {
        if (rectifyK.get(0, 1) != 0.0) {
            throw new IllegalArgumentException("Skew should be zero in rectified images");
        }
        Point2Transform2_F64 remove_p_to_p = LensDistortionFactory.narrow(param).undistort_F64(true, true);
        PointTransformHomography_F64 rectifyDistort = new PointTransformHomography_F64(rectify);
        PinholePtoN_F64 pixelToNorm = new PinholePtoN_F64();
        pixelToNorm.set(rectifyK.get(0, 0), rectifyK.get(1, 1), rectifyK.get(0, 1), rectifyK.get(0, 2), rectifyK.get(1, 2));
        return new SequencePoint2Transform2_F64(new Point2Transform2_F64[]{remove_p_to_p, rectifyDistort, pixelToNorm});
    }
}

