/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.PerspectiveOps;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import javax.annotation.Nullable;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.ReshapeMatrix;

public abstract class BundleAdjustmentProjectiveSchurJacobian<M extends DMatrix>
implements BundleAdjustmentSchur.Jacobian<SceneStructureProjective, M> {
    private SceneStructureProjective structure;
    private SceneObservations observations;
    private DMatrixRMaj worldToView = new DMatrixRMaj(3, 4);
    private int numViewsUnknown;
    private int numParameters;
    private int lengthPoint;
    private Point4D_F64 worldPt = new Point4D_F64();
    private Point3D_F64 pixelH = new Point3D_F64();
    private int indexFirstView;
    private int indexLastView;
    private int[] viewParameterIndexes;
    private int[] cameraParameterIndexes;
    private int jacRowX;
    private int jacRowY;
    private double[] worldGradX = new double[4];
    private double[] worldGradY = new double[4];
    private double[] worldGradZ = new double[4];
    private double[] camGradX = new double[12];
    private double[] camGradY = new double[12];
    private double[] camGradZ = new double[12];
    private double[] pixelhGradX = new double[3];
    private double[] pixelhGradY = new double[3];
    private double[] intrGradX = null;
    private double[] intrGradY = null;
    private double[] chainRuleX = new double[12];
    private double[] chainRuleY = new double[12];

    @Override
    public void configure(SceneStructureProjective structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
        if (!structure.isHomogenous()) {
            this.worldPt.w = 1.0;
            this.lengthPoint = 3;
        } else {
            this.lengthPoint = 4;
        }
        this.numViewsUnknown = structure.getUnknownViewCount();
        int numCameraParameters = structure.getUnknownCameraParameterCount();
        this.indexFirstView = structure.points.size * this.lengthPoint;
        this.indexLastView = this.indexFirstView + this.numViewsUnknown * 12;
        this.numParameters = this.indexLastView + numCameraParameters;
        this.viewParameterIndexes = new int[structure.views.size];
        int index = 0;
        for (int i = 0; i < structure.views.size; ++i) {
            this.viewParameterIndexes[i] = index;
            if (((SceneStructureProjective.View[])structure.views.data)[i].known) continue;
            index += 12;
        }
        this.cameraParameterIndexes = new int[structure.cameras.size];
        int largestCameraSize = 0;
        int index2 = 0;
        for (int i = 0; i < structure.cameras.size; ++i) {
            if (((SceneStructureCommon.Camera)structure.cameras.get((int)i)).known) continue;
            this.cameraParameterIndexes[i] = index2;
            int count = ((SceneStructureCommon.Camera[])structure.cameras.data)[i].model.getIntrinsicCount();
            largestCameraSize = Math.max(largestCameraSize, count);
            index2 += count;
        }
        this.intrGradX = new double[largestCameraSize];
        this.intrGradY = new double[largestCameraSize];
    }

    public int getNumOfInputsN() {
        return this.numParameters;
    }

    public int getNumOfOutputsM() {
        return this.observations.getObservationCount() * 2;
    }

    public void processInternal(double[] input, DMatrix leftPoint, DMatrix rightView) {
        int numRows = this.getNumOfOutputsM();
        int numPointParam = this.structure.points.size * this.lengthPoint;
        int numViewParam = this.numParameters - numPointParam;
        ((ReshapeMatrix)leftPoint).reshape(numRows, numPointParam);
        ((ReshapeMatrix)rightView).reshape(numRows, numViewParam);
        leftPoint.zero();
        rightView.zero();
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.size; ++viewIndex) {
            int i;
            SceneStructureProjective.View view = ((SceneStructureProjective.View[])this.structure.views.data)[viewIndex];
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])this.structure.cameras.data)[view.camera];
            int cameraParamStartIndex = this.cameraParameterIndexes[view.camera];
            if (!view.known) {
                int paramIndex = this.viewParameterIndexes[viewIndex] + this.indexFirstView;
                for (i = 0; i < 12; ++i) {
                    this.worldToView.data[i] = input[paramIndex++];
                }
            } else {
                this.worldToView.set((DMatrixD1)view.worldToView);
            }
            SceneObservations.View obsView = ((SceneObservations.View[])this.observations.views.data)[viewIndex];
            for (i = 0; i < obsView.size(); ++i) {
                int j;
                int featureIndex = obsView.point.get(i);
                int columnOfPointInJac = featureIndex * this.lengthPoint;
                this.worldPt.x = input[columnOfPointInJac];
                this.worldPt.y = input[columnOfPointInJac + 1];
                this.worldPt.z = input[columnOfPointInJac + 2];
                if (this.structure.isHomogenous()) {
                    this.worldPt.w = input[columnOfPointInJac + 3];
                }
                PerspectiveOps.renderPixel(this.worldToView, this.worldPt, this.pixelH);
                if (view.known) {
                    if (this.structure.isHomogenous()) {
                        BundleAdjustmentProjectiveSchurJacobian.partialCameraMatrixH(this.worldPt.x, this.worldPt.y, this.worldPt.z, this.worldPt.w, this.worldToView, this.worldGradX, this.worldGradY, this.worldGradZ, null, null, null);
                    } else {
                        BundleAdjustmentProjectiveSchurJacobian.partialCameraMatrix(this.worldPt.x, this.worldPt.y, this.worldPt.z, this.worldToView, this.worldGradX, this.worldGradY, this.worldGradZ, null, null, null);
                    }
                } else if (this.structure.isHomogenous()) {
                    BundleAdjustmentProjectiveSchurJacobian.partialCameraMatrixH(this.worldPt.x, this.worldPt.y, this.worldPt.z, this.worldPt.w, this.worldToView, this.worldGradX, this.worldGradY, this.worldGradZ, this.camGradX, this.camGradY, this.camGradZ);
                } else {
                    BundleAdjustmentProjectiveSchurJacobian.partialCameraMatrix(this.worldPt.x, this.worldPt.y, this.worldPt.z, this.worldToView, this.worldGradX, this.worldGradY, this.worldGradZ, this.camGradX, this.camGradY, this.camGradZ);
                }
                this.jacRowX = observationIndex * 2;
                this.jacRowY = this.jacRowX + 1;
                if (!camera.known) {
                    int N = camera.model.getIntrinsicCount();
                    camera.model.jacobian(this.pixelH.x, this.pixelH.y, this.pixelH.z, this.pixelhGradX, this.pixelhGradY, true, this.intrGradX, this.intrGradY);
                    int location = this.indexLastView - this.indexFirstView + cameraParamStartIndex;
                    for (int j2 = 0; j2 < N; ++j2) {
                        this.set(rightView, this.jacRowX, location + j2, this.intrGradX[j2]);
                        this.set(rightView, this.jacRowY, location + j2, this.intrGradY[j2]);
                    }
                } else {
                    camera.model.jacobian(this.pixelH.x, this.pixelH.y, this.pixelH.z, this.pixelhGradX, this.pixelhGradY, false, null, null);
                }
                for (j = 0; j < this.lengthPoint; ++j) {
                    this.chainRuleX[j] = this.pixelhGradX[0] * this.worldGradX[j] + this.pixelhGradX[1] * this.worldGradY[j] + this.pixelhGradX[2] * this.worldGradZ[j];
                    this.chainRuleY[j] = this.pixelhGradY[0] * this.worldGradX[j] + this.pixelhGradY[1] * this.worldGradY[j] + this.pixelhGradY[2] * this.worldGradZ[j];
                }
                this.addToJacobian(leftPoint, columnOfPointInJac, this.lengthPoint, this.chainRuleX, this.chainRuleY);
                if (!view.known) {
                    for (j = 0; j < 12; ++j) {
                        this.chainRuleX[j] = this.pixelhGradX[0] * this.camGradX[j] + this.pixelhGradX[1] * this.camGradY[j] + this.pixelhGradX[2] * this.camGradZ[j];
                        this.chainRuleY[j] = this.pixelhGradY[0] * this.camGradX[j] + this.pixelhGradY[1] * this.camGradY[j] + this.pixelhGradY[2] * this.camGradZ[j];
                    }
                    int col = this.viewParameterIndexes[viewIndex];
                    this.addToJacobian(rightView, col, 12, this.chainRuleX, this.chainRuleY);
                }
                ++observationIndex;
            }
        }
    }

    static void partialCameraMatrix(double X, double Y, double Z, DMatrixRMaj P, double[] pointGradX, double[] pointGradY, double[] pointGradZ, @Nullable double[] camGradX, @Nullable double[] camGradY, @Nullable double[] camGradZ) {
        double P11 = P.data[0];
        double P12 = P.data[1];
        double P13 = P.data[2];
        double P14 = P.data[3];
        double P21 = P.data[4];
        double P22 = P.data[5];
        double P23 = P.data[6];
        double P24 = P.data[7];
        double P31 = P.data[8];
        double P32 = P.data[9];
        double P33 = P.data[10];
        double P34 = P.data[11];
        pointGradX[0] = P11;
        pointGradX[1] = P12;
        pointGradX[2] = P13;
        pointGradY[0] = P21;
        pointGradY[1] = P22;
        pointGradY[2] = P23;
        pointGradZ[0] = P31;
        pointGradZ[1] = P32;
        pointGradZ[2] = P33;
        if (camGradX == null || camGradY == null || camGradZ == null) {
            return;
        }
        camGradX[0] = X;
        camGradX[1] = Y;
        camGradX[2] = Z;
        camGradX[3] = 1.0;
        camGradX[4] = 0.0;
        camGradX[5] = 0.0;
        camGradX[6] = 0.0;
        camGradX[7] = 0.0;
        camGradX[8] = 0.0;
        camGradX[9] = 0.0;
        camGradX[10] = 0.0;
        camGradX[11] = 0.0;
        camGradY[0] = 0.0;
        camGradY[1] = 0.0;
        camGradY[2] = 0.0;
        camGradY[3] = 0.0;
        camGradY[4] = X;
        camGradY[5] = Y;
        camGradY[6] = Z;
        camGradY[7] = 1.0;
        camGradY[8] = 0.0;
        camGradY[9] = 0.0;
        camGradY[10] = 0.0;
        camGradY[11] = 0.0;
        camGradZ[0] = 0.0;
        camGradZ[1] = 0.0;
        camGradZ[2] = 0.0;
        camGradZ[3] = 0.0;
        camGradZ[4] = 0.0;
        camGradZ[5] = 0.0;
        camGradZ[6] = 0.0;
        camGradZ[7] = 0.0;
        camGradZ[8] = X;
        camGradZ[9] = Y;
        camGradZ[10] = Z;
        camGradZ[11] = 1.0;
    }

    static void partialCameraMatrixH(double X, double Y, double Z, double W, DMatrixRMaj P, double[] pointGradX, double[] pointGradY, double[] pointGradZ, @Nullable double[] camGradX, @Nullable double[] camGradY, @Nullable double[] camGradZ) {
        double P11 = P.data[0];
        double P12 = P.data[1];
        double P13 = P.data[2];
        double P14 = P.data[3];
        double P21 = P.data[4];
        double P22 = P.data[5];
        double P23 = P.data[6];
        double P24 = P.data[7];
        double P31 = P.data[8];
        double P32 = P.data[9];
        double P33 = P.data[10];
        double P34 = P.data[11];
        pointGradX[0] = P11;
        pointGradX[1] = P12;
        pointGradX[2] = P13;
        pointGradX[3] = P14;
        pointGradY[0] = P21;
        pointGradY[1] = P22;
        pointGradY[2] = P23;
        pointGradY[3] = P24;
        pointGradZ[0] = P31;
        pointGradZ[1] = P32;
        pointGradZ[2] = P33;
        pointGradZ[3] = P34;
        if (camGradX == null || camGradY == null || camGradZ == null) {
            return;
        }
        camGradX[0] = X;
        camGradX[1] = Y;
        camGradX[2] = Z;
        camGradX[3] = W;
        camGradX[4] = 0.0;
        camGradX[5] = 0.0;
        camGradX[6] = 0.0;
        camGradX[7] = 0.0;
        camGradX[8] = 0.0;
        camGradX[9] = 0.0;
        camGradX[10] = 0.0;
        camGradX[11] = 0.0;
        camGradY[0] = 0.0;
        camGradY[1] = 0.0;
        camGradY[2] = 0.0;
        camGradY[3] = 0.0;
        camGradY[4] = X;
        camGradY[5] = Y;
        camGradY[6] = Z;
        camGradY[7] = W;
        camGradY[8] = 0.0;
        camGradY[9] = 0.0;
        camGradY[10] = 0.0;
        camGradY[11] = 0.0;
        camGradZ[0] = 0.0;
        camGradZ[1] = 0.0;
        camGradZ[2] = 0.0;
        camGradZ[3] = 0.0;
        camGradZ[4] = 0.0;
        camGradZ[5] = 0.0;
        camGradZ[6] = 0.0;
        camGradZ[7] = 0.0;
        camGradZ[8] = X;
        camGradZ[9] = Y;
        camGradZ[10] = Z;
        camGradZ[11] = W;
    }

    private void addToJacobian(DMatrix tripplet, int col, int length, double[] a, double[] b) {
        for (int i = 0; i < length; ++i) {
            this.set(tripplet, this.jacRowX, col + i, a[i]);
            this.set(tripplet, this.jacRowY, col + i, b[i]);
        }
    }

    protected abstract void set(DMatrix var1, int var2, int var3, double var4);
}

