/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.brown;

import boofcv.alg.distort.brown.RadialTangential_F32;
import boofcv.alg.distort.brown.RemoveBrownNtoN_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F32;

public class RemoveBrownPtoN_F32
implements Point2Transform2_F32 {
    protected float cx;
    protected float cy;
    protected float fx;
    protected float fy;
    protected float skew;
    protected RadialTangential_F32 params;
    private float a11;
    private float a12;
    private float a13;
    private float a22;
    private float a23;
    private float tol = GrlConstants.FCONV_TOL_A;

    public RemoveBrownPtoN_F32() {
    }

    public RemoveBrownPtoN_F32(float tol) {
        this.tol = tol;
    }

    public void setTolerance(float tol) {
        this.tol = tol;
    }

    public RemoveBrownPtoN_F32 setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = (float)fx;
        this.fy = (float)fy;
        this.skew = (float)skew;
        this.cx = (float)cx;
        this.cy = (float)cy;
        this.a11 = (float)(1.0 / fx);
        this.a12 = (float)(-skew / (fx * fy));
        this.a13 = (float)((skew * cy - cx * fy) / (fx * fy));
        this.a22 = (float)(1.0 / fy);
        this.a23 = (float)(-cy / fy);
        return this;
    }

    public RemoveBrownPtoN_F32 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F32(radial, t1, t2);
        return this;
    }

    public void compute(float x, float y, Point2D_F32 out) {
        out.x = this.a11 * x + this.a12 * y + this.a13;
        out.y = this.a22 * y + this.a23;
        RemoveBrownNtoN_F32.removeRadial(out.x, out.y, this.params.radial, this.params.t1, this.params.t2, out, this.tol);
    }

    public RemoveBrownPtoN_F32 copyConcurrent() {
        RemoveBrownPtoN_F32 ret = new RemoveBrownPtoN_F32(this.tol);
        ret.fx = this.fx;
        ret.fy = this.fy;
        ret.skew = this.skew;
        ret.cx = this.cx;
        ret.cy = this.cy;
        ret.a11 = this.a11;
        ret.a12 = this.a12;
        ret.a13 = this.a13;
        ret.a22 = this.a22;
        ret.a23 = this.a23;
        ret.params = new RadialTangential_F32(this.params);
        return ret;
    }
}

