/*
 * Copyright (c) 2011-2019, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.abst.geo.bundle;

import org.ddogleg.optimization.UnconstrainedLeastSquaresSchur;
import org.ejml.data.DMatrixRMaj;

/**
 * Implementation of {@link BundleAdjustmentSchur} for dense matrices
 *
 * @author Peter Abeles
 */
public class BundleAdjustmentSchur_DDRM<Structure extends SceneStructure>
		extends BundleAdjustmentSchur<Structure, DMatrixRMaj>
{
	public BundleAdjustmentSchur_DDRM(UnconstrainedLeastSquaresSchur<DMatrixRMaj> minimizer,
									  FunctionResiduals<Structure> function,
									  Jacobian<Structure, DMatrixRMaj> jacobian,
									  Codec<Structure> codec)
	{
		super(minimizer, function, jacobian, codec);
	}
}
