/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.struct.feature.PackedTupleArray;
import boofcv.struct.feature.TupleDesc_F32;
import georegression.struct.packed.PackedArray;
import org.ddogleg.struct.DogArray_F32;

public class PackedTupleArray_F32
implements PackedTupleArray<TupleDesc_F32> {
    public final int dof;
    public final DogArray_F32 array;
    public final TupleDesc_F32 temp;
    protected int numElements;

    public PackedTupleArray_F32(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_F32(dof);
        this.array = new DogArray_F32();
        this.array.resize(0);
    }

    public void removeSwap(int index) {
        int where = (index + 1) * this.dof - 1;
        for (int i = 0; i < this.dof; ++i) {
            this.array.removeSwap(where--);
        }
    }

    public PackedTupleArray_F32 reset() {
        this.numElements = 0;
        this.array.reset();
        return this;
    }

    public PackedTupleArray_F32 reserve(int numTuples) {
        this.array.reserve(numTuples * this.dof);
        return this;
    }

    public void append(TupleDesc_F32 element) {
        this.array.addAll(element.data, 0, this.dof);
        ++this.numElements;
    }

    public void set(int index, TupleDesc_F32 element) {
        System.arraycopy(element.data, 0, this.array.data, index * this.dof, this.dof);
    }

    public TupleDesc_F32 getTemp(int index) {
        System.arraycopy(this.array.data, index * this.dof, this.temp.data, 0, this.dof);
        return this.temp;
    }

    public void getCopy(int index, TupleDesc_F32 dst) {
        System.arraycopy(this.array.data, index * this.dof, dst.data, 0, this.dof);
    }

    public void copy(TupleDesc_F32 src, TupleDesc_F32 dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.dof);
    }

    public int size() {
        return this.numElements;
    }

    public Class<TupleDesc_F32> getElementType() {
        return TupleDesc_F32.class;
    }

    public void forIdx(int idx0, int idx1, PackedArray.ProcessIndex<TupleDesc_F32> op) {
        int pointIndex = idx0;
        idx1 *= this.dof;
        for (int i = idx0 *= this.dof; i < idx1; i += this.dof) {
            System.arraycopy(this.array.data, i, this.temp.data, 0, this.dof);
            op.process(pointIndex++, (Object)this.temp);
        }
    }

    public boolean isEquals(PackedArray<TupleDesc_F32> other) {
        return this.array.isEquals(((PackedTupleArray_F32)other).array);
    }

    @Override
    public int getDOF() {
        return this.dof;
    }
}

