/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polyline;

import boofcv.alg.shapes.polyline.FitLinesToContour;
import boofcv.misc.CircularIndex;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.DogArray_I32;

public class MinimizeEnergyPrune {
    double splitPenalty;
    LineParametric2D_F64 line = new LineParametric2D_F64();
    Point2D_F64 point = new Point2D_F64();
    List<Point2D_I32> contour;
    double[] energySegment = new double[1];
    DogArray_I32 bestCorners = new DogArray_I32();
    DogArray_I32 workCorners1 = new DogArray_I32();
    DogArray_I32 workCorners2 = new DogArray_I32();

    public MinimizeEnergyPrune(double splitPenalty) {
        this.splitPenalty = splitPenalty;
    }

    public boolean prune(List<Point2D_I32> contour, DogArray_I32 input, DogArray_I32 output) {
        this.contour = contour;
        output.setTo(input);
        this.removeDuplicates(output);
        if (output.size() <= 3) {
            return false;
        }
        this.computeSegmentEnergy(output);
        double total = 0.0;
        for (int i = 0; i < output.size(); ++i) {
            total += this.energySegment[i];
        }
        FitLinesToContour fit = new FitLinesToContour();
        fit.setContour(contour);
        boolean modified = false;
        while (output.size() > 3) {
            double bestEnergy = total;
            boolean betterFound = false;
            this.bestCorners.reset();
            for (int i = 0; i < output.size(); ++i) {
                int anchor1;
                int anchor0;
                this.workCorners1.reset();
                for (int j = 0; j < output.size(); ++j) {
                    if (i == j) continue;
                    this.workCorners1.add(output.get(j));
                }
                this.removeDuplicates(this.workCorners1);
                if (this.workCorners1.size() <= 3 || !fit.fitAnchored(anchor0 = CircularIndex.addOffset((int)i, (int)-2, (int)this.workCorners1.size()), anchor1 = CircularIndex.addOffset((int)i, (int)1, (int)this.workCorners1.size()), this.workCorners1, this.workCorners2)) continue;
                double score = 0.0;
                int j = 0;
                int k = this.workCorners2.size() - 1;
                while (j < this.workCorners2.size()) {
                    score += this.computeSegmentEnergy(this.workCorners2, k, j);
                    k = j++;
                }
                if (!(score < bestEnergy)) continue;
                betterFound = true;
                bestEnergy = score;
                this.bestCorners.reset();
                this.bestCorners.addAll(this.workCorners2);
            }
            if (!betterFound) break;
            modified = true;
            total = bestEnergy;
            output.setTo(this.bestCorners);
        }
        return modified;
    }

    void removeDuplicates(DogArray_I32 corners) {
        for (int i = 0; i < corners.size(); ++i) {
            Point2D_I32 a = this.contour.get(corners.get(i));
            for (int j = corners.size() - 1; j > i; --j) {
                Point2D_I32 b = this.contour.get(corners.get(j));
                if (a.x != b.x || a.y != b.y) continue;
                corners.remove(j);
            }
        }
    }

    void computeSegmentEnergy(DogArray_I32 corners) {
        if (this.energySegment.length < corners.size()) {
            this.energySegment = new double[corners.size()];
        }
        int i = 0;
        int j = corners.size() - 1;
        while (i < corners.size()) {
            this.energySegment[j] = this.computeSegmentEnergy(corners, j, i);
            j = i++;
        }
    }

    protected double energyRemoveCorner(int removed, DogArray_I32 corners) {
        double total = 0.0;
        int cornerA = CircularIndex.addOffset((int)removed, (int)-1, (int)corners.size());
        int cornerB = CircularIndex.addOffset((int)removed, (int)1, (int)corners.size());
        total += this.computeSegmentEnergy(corners, cornerA, cornerB);
        if (cornerA > cornerB) {
            for (int i = cornerB; i < cornerA; ++i) {
                total += this.energySegment[i];
            }
        } else {
            int i;
            for (i = 0; i < cornerA; ++i) {
                total += this.energySegment[i];
            }
            for (i = cornerB; i < corners.size(); ++i) {
                total += this.energySegment[i];
            }
        }
        return total;
    }

    protected double computeSegmentEnergy(DogArray_I32 corners, int cornerA, int cornerB) {
        int indexB;
        int indexA = corners.get(cornerA);
        if (indexA == (indexB = corners.get(cornerB))) {
            return 100000.0;
        }
        Point2D_I32 a = this.contour.get(indexA);
        Point2D_I32 b = this.contour.get(indexB);
        this.line.p.x = a.x;
        this.line.p.y = a.y;
        this.line.slope.setTo((double)(b.x - a.x), (double)(b.y - a.y));
        double total = 0.0;
        int length = this.circularDistance(indexA, indexB);
        for (int k = 1; k < length; ++k) {
            Point2D_I32 c = this.getContour(indexA + 1 + k);
            this.point.setTo((double)c.x, (double)c.y);
            total += Distance2D_F64.distanceSq((LineParametric2D_F64)this.line, (Point2D_F64)this.point);
        }
        return (total + this.splitPenalty) / (double)a.distance2(b);
    }

    protected Point2D_I32 getContour(int index) {
        return this.contour.get(index % this.contour.size());
    }

    protected int circularDistance(int start, int end) {
        return CircularIndex.distanceP((int)start, (int)end, (int)this.contour.size());
    }
}

