/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.flow;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.flow.BroxWarpingSpacial_to_DenseOpticalFlow;
import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.abst.flow.FlowBlock_to_DenseOpticalFlow;
import boofcv.abst.flow.FlowKlt_to_DenseOpticalFlow;
import boofcv.abst.flow.HornSchunckPyramid_to_DenseOpticalFlow;
import boofcv.abst.flow.HornSchunck_to_DenseOpticalFlow;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.flow.BroxWarpingSpacial;
import boofcv.alg.flow.ConfigBroxWarping;
import boofcv.alg.flow.DenseOpticalFlowBlockPyramid;
import boofcv.alg.flow.DenseOpticalFlowKlt;
import boofcv.alg.flow.HornSchunck;
import boofcv.alg.flow.HornSchunckPyramid;
import boofcv.alg.flow.HornSchunck_F32;
import boofcv.alg.flow.HornSchunck_U8;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.tracker.klt.ConfigPKlt;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.flow.ConfigHornSchunck;
import boofcv.factory.flow.ConfigHornSchunckPyramid;
import boofcv.factory.flow.ConfigOpticalFlowBlockPyramid;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.factory.tracker.FactoryTrackerAlg;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.PyramidDiscrete;
import org.jetbrains.annotations.Nullable;

public class FactoryDenseOpticalFlow {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> DenseOpticalFlow<I> flowKlt(@Nullable ConfigPKlt configKlt, int radius, Class<I> inputType, Class<D> derivType) {
        if (configKlt == null) {
            configKlt = new ConfigPKlt();
            configKlt.pyramidLevels = ConfigDiscreteLevels.levels((int)3);
        }
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        ImageType imagetype = ImageType.single(inputType);
        PyramidDiscrete pyramidA = FactoryPyramid.discreteGaussian((ConfigDiscreteLevels)configKlt.pyramidLevels, (double)-1.0, (int)2, (boolean)true, (ImageType)imagetype);
        PyramidDiscrete pyramidB = FactoryPyramid.discreteGaussian((ConfigDiscreteLevels)configKlt.pyramidLevels, (double)-1.0, (int)2, (boolean)true, (ImageType)imagetype);
        PyramidKltTracker tracker = FactoryTrackerAlg.kltPyramid(configKlt.config, inputType, derivType);
        DenseOpticalFlowKlt flowKlt = new DenseOpticalFlowKlt(tracker, radius);
        ImageGradient gradient = FactoryDerivative.sobel(inputType, (Class)derivType);
        return new FlowKlt_to_DenseOpticalFlow(flowKlt, gradient, pyramidA, pyramidB, inputType, derivType);
    }

    public static <T extends ImageGray<T>> DenseOpticalFlow<T> region(@Nullable ConfigOpticalFlowBlockPyramid config, Class<T> imageType) {
        DenseOpticalFlowBlockPyramid alg;
        if (config == null) {
            config = new ConfigOpticalFlowBlockPyramid();
        }
        if (imageType == GrayU8.class) {
            alg = new DenseOpticalFlowBlockPyramid.U8(config.searchRadius, config.regionRadius, config.maxPerPixelError);
        } else if (imageType == GrayF32.class) {
            alg = new DenseOpticalFlowBlockPyramid.F32(config.searchRadius, config.regionRadius, config.maxPerPixelError);
        } else {
            throw new IllegalArgumentException("Unsupported image type " + String.valueOf(imageType));
        }
        return new FlowBlock_to_DenseOpticalFlow<GrayU8>(alg, config.pyramidScale, config.maxPyramidLayers, imageType);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> DenseOpticalFlow<T> hornSchunck(@Nullable ConfigHornSchunck config, Class<T> imageType) {
        HornSchunck alg;
        if (config == null) {
            config = new ConfigHornSchunck();
        }
        if (imageType == GrayU8.class) {
            alg = new HornSchunck_U8(config.alpha, config.numIterations);
        } else if (imageType == GrayF32.class) {
            alg = new HornSchunck_F32(config.alpha, config.numIterations);
        } else {
            throw new IllegalArgumentException("Unsupported image type " + String.valueOf(imageType));
        }
        return new HornSchunck_to_DenseOpticalFlow<GrayU8, GrayS16>(alg, ImageType.single(imageType));
    }

    public static <T extends ImageGray<T>> DenseOpticalFlow<T> hornSchunckPyramid(@Nullable ConfigHornSchunckPyramid config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigHornSchunckPyramid();
        }
        InterpolatePixelS interpolate = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (InterpolationType)config.interpolation, (BorderType)BorderType.EXTENDED, GrayF32.class);
        HornSchunckPyramid alg = new HornSchunckPyramid(config, (InterpolatePixelS<GrayF32>)interpolate);
        return new HornSchunckPyramid_to_DenseOpticalFlow(alg, imageType);
    }

    public static <T extends ImageGray<T>> DenseOpticalFlow<T> broxWarping(@Nullable ConfigBroxWarping config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigBroxWarping();
        }
        InterpolatePixelS interpolate = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (InterpolationType)config.interpolation, (BorderType)BorderType.EXTENDED, GrayF32.class);
        BroxWarpingSpacial alg = new BroxWarpingSpacial(config, (InterpolatePixelS<GrayF32>)interpolate);
        return new BroxWarpingSpacial_to_DenseOpticalFlow(alg, imageType);
    }
}

