/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.describe;

import boofcv.abst.feature.convert.ConvertTupleDesc;
import boofcv.abst.feature.describe.ConfigBrief;
import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.ConfigTemplateDescribe;
import boofcv.abst.feature.describe.DescribeBriefSO_RadiusAngle;
import boofcv.abst.feature.describe.DescribeBrief_RadiusAngle;
import boofcv.abst.feature.describe.DescribeNCC_RadiusAngle;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.feature.describe.DescribePointRadiusAngleConvertImage;
import boofcv.abst.feature.describe.DescribePointRadiusAngleConvertTuple;
import boofcv.abst.feature.describe.DescribePointRawPixels_RadiusAngle;
import boofcv.abst.feature.describe.DescribeSift_RadiusAngle;
import boofcv.abst.feature.describe.DescribeSurfPlanar_RadiusAngle;
import boofcv.abst.feature.describe.DescribeSurf_RadiusAngle;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.describe.DescribePointSurfPlanar;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.alg.feature.describe.brief.FactoryBriefDefinition;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.describe.ConfigConvertTupleDesc;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.describe.FactoryConvertTupleDesc;
import boofcv.factory.feature.describe.FactoryDescribeAlgs;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public class FactoryDescribePointRadiusAngle {
    public static <T extends ImageBase<T>, TD extends TupleDesc<TD>> DescribePointRadiusAngle<T, TD> generic(ConfigDescribeRegion config, ImageType<T> imageType) {
        DescribePointRadiusAngle<T, TD> ret;
        Class imageClass = imageType.getImageClass();
        switch (config.type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SURF_FAST: {
                DescribePointRadiusAngle<T, TD> describePointRadiusAngle = FactoryDescribePointRadiusAngle.wrapIf(FactoryDescribePointRadiusAngle.surfFast(config.surfFast, imageClass), imageType);
                break;
            }
            case SURF_STABLE: {
                DescribePointRadiusAngle<T, TD> describePointRadiusAngle = FactoryDescribePointRadiusAngle.wrapIf(FactoryDescribePointRadiusAngle.surfStable(config.surfStability, imageClass), imageType);
                break;
            }
            case SURF_COLOR_FAST: {
                DescribePointRadiusAngle<T, TD> describePointRadiusAngle = FactoryDescribePointRadiusAngle.wrapIf(FactoryDescribePointRadiusAngle.surfColorFast(config.surfFast, imageType), imageType);
                break;
            }
            case SURF_COLOR_STABLE: {
                DescribePointRadiusAngle<T, TD> describePointRadiusAngle = FactoryDescribePointRadiusAngle.wrapIf(FactoryDescribePointRadiusAngle.surfColorStable(config.surfStability, imageType), imageType);
                break;
            }
            case SIFT: {
                DescribePointRadiusAngle<T, TD> describePointRadiusAngle = FactoryDescribePointRadiusAngle.wrapIf(FactoryDescribePointRadiusAngle.sift(config.scaleSpaceSift, config.sift, imageClass), imageType);
                break;
            }
            case BRIEF: {
                DescribePointRadiusAngle<T, TD> describePointRadiusAngle = FactoryDescribePointRadiusAngle.wrapIf(FactoryDescribePointRadiusAngle.brief(config.brief, imageClass), imageType);
                break;
            }
            case TEMPLATE: {
                DescribePointRadiusAngle<T, TD> describePointRadiusAngle = ret = FactoryDescribePointRadiusAngle.wrapIf(FactoryDescribePointRadiusAngle.template(config.template, imageClass), imageType);
            }
        }
        if (config.convert.outputData == ConfigConvertTupleDesc.DataType.NATIVE) {
            return ret;
        }
        int dof = ret.createDescription().size();
        ConvertTupleDesc converter = FactoryConvertTupleDesc.generic(config.convert, dof, ret.getDescriptionType());
        return new DescribePointRadiusAngleConvertTuple(ret, converter);
    }

    private static <T extends ImageBase<T>, TD extends TupleDesc<TD>> DescribePointRadiusAngle<T, TD> wrapIf(DescribePointRadiusAngle alg, ImageType<T> imageType) {
        if (alg.getImageType().isSameType(imageType)) {
            return alg;
        }
        return new DescribePointRadiusAngleConvertImage(alg, imageType);
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DescribePointRadiusAngle<T, TupleDesc_F64> surfFast(@Nullable ConfigSurfDescribe.Fast config, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        DescribePointSurf alg = FactoryDescribeAlgs.surfSpeed(config, integralType);
        return new DescribeSurf_RadiusAngle(alg, imageType);
    }

    public static <T extends ImageMultiBand<T>, II extends ImageGray<II>> DescribePointRadiusAngle<T, TupleDesc_F64> surfColorFast(@Nullable ConfigSurfDescribe.Fast config, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        DescribePointSurf alg = FactoryDescribeAlgs.surfSpeed(config, integralType);
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            DescribePointSurfPlanar color = FactoryDescribeAlgs.surfColor(alg, imageType.getNumBands());
            return new DescribeSurfPlanar_RadiusAngle(color, bandType, integralType);
        }
        throw new IllegalArgumentException("Unsupported image family. " + String.valueOf(imageType.getFamily()));
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DescribePointRadiusAngle<T, TupleDesc_F64> surfStable(@Nullable ConfigSurfDescribe.Stability config, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        DescribePointSurfMod alg = FactoryDescribeAlgs.surfStability(config, integralType);
        return new DescribeSurf_RadiusAngle(alg, imageType);
    }

    public static <T extends ImageBase<T>, II extends ImageGray<II>> DescribePointRadiusAngle<T, TupleDesc_F64> surfColorStable(@Nullable ConfigSurfDescribe.Stability config, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        DescribePointSurfMod alg = FactoryDescribeAlgs.surfStability(config, integralType);
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            DescribePointSurfPlanar color = FactoryDescribeAlgs.surfColor(alg, imageType.getNumBands());
            return new DescribeSurfPlanar_RadiusAngle(color, bandType, integralType);
        }
        throw new IllegalArgumentException("Unsupported image family. " + String.valueOf(imageType.getFamily()));
    }

    public static <T extends ImageGray<T>> DescribePointRadiusAngle<T, TupleDesc_F64> sift(@Nullable ConfigSiftScaleSpace configSS, @Nullable ConfigSiftDescribe configDescribe, Class<T> imageType) {
        if (configSS == null) {
            configSS = new ConfigSiftScaleSpace();
        }
        configSS.checkValidity();
        SiftScaleSpace ss = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        DescribePointSift<GrayF32> alg = FactoryDescribeAlgs.sift(configDescribe, GrayF32.class);
        return new DescribeSift_RadiusAngle<T>(ss, alg, imageType);
    }

    public static <T extends ImageGray<T>> DescribePointRadiusAngle<T, TupleDesc_B> brief(@Nullable ConfigBrief config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigBrief();
        }
        config.checkValidity();
        BlurStorageFilter filter = FactoryBlurFilter.gaussian((ImageType)ImageType.single(imageType), (double)config.blurSigma, (int)config.blurRadius);
        BinaryCompareDefinition_I32 definition = FactoryBriefDefinition.gaussian2(new Random(123L), config.radius, config.numPoints);
        if (config.fixed) {
            return new DescribeBrief_RadiusAngle(FactoryDescribeAlgs.brief(definition, filter), imageType);
        }
        return new DescribeBriefSO_RadiusAngle(FactoryDescribeAlgs.briefso(definition, filter), imageType);
    }

    public static <T extends ImageGray<T>, TD extends TupleDesc<TD>> DescribePointRadiusAngle<T, TD> template(@Nullable ConfigTemplateDescribe config, Class<T> imageType) {
        DescribePointRadiusAngle describePointRadiusAngle;
        if (config == null) {
            config = new ConfigTemplateDescribe();
        }
        switch (config.type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PIXEL: {
                describePointRadiusAngle = new DescribePointRawPixels_RadiusAngle(FactoryDescribeAlgs.pixelRegion(config.width, config.height, imageType), imageType);
                break;
            }
            case NCC: {
                describePointRadiusAngle = new DescribeNCC_RadiusAngle<T>(FactoryDescribeAlgs.pixelRegionNCC(config.width, config.height, imageType), imageType);
            }
        }
        return describePointRadiusAngle;
    }

    public static <T extends ImageGray<T>, TD extends TupleDesc<TD>> DescribePointRadiusAngle<T, TD> pixel(int regionWidth, int regionHeight, Class<T> imageType) {
        return new DescribePointRawPixels_RadiusAngle(FactoryDescribeAlgs.pixelRegion(regionWidth, regionHeight, imageType), imageType);
    }

    public static <T extends ImageGray<T>> DescribePointRadiusAngle<T, NccFeature> pixelNCC(int regionWidth, int regionHeight, Class<T> imageType) {
        return new DescribeNCC_RadiusAngle<T>(FactoryDescribeAlgs.pixelRegionNCC(regionWidth, regionHeight, imageType), imageType);
    }
}

