/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribePoint;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class DescribeSurf_Point<T extends ImageGray<T>, II extends ImageGray<II>>
implements DescribePoint<T, TupleDesc_F64> {
    public double regionRadius;
    protected DescribePointSurf<II> surf;
    protected OrientationIntegral<II> orientation;
    II ii;
    ImageType<T> imageType;
    final double canonicalRadius;

    public DescribeSurf_Point(DescribePointSurf<II> surf, OrientationIntegral<II> orientation, double regionRadius, Class<T> imageType) {
        this.surf = surf;
        this.orientation = orientation;
        this.imageType = ImageType.single(imageType);
        this.regionRadius = regionRadius;
        this.canonicalRadius = (double)surf.getCanonicalWidth() / 2.0;
    }

    @Override
    public void setImage(T image) {
        if (this.ii != null) {
            this.ii.reshape(((ImageGray)image).width, ((ImageGray)image).height);
        }
        this.ii = GIntegralImageOps.transform(image, this.ii);
        this.surf.setImage(this.ii);
        this.orientation.setImage(this.ii);
        if (this.regionRadius <= 0.0) {
            this.regionRadius = this.canonicalRadius;
        }
        this.orientation.setObjectRadius(this.regionRadius);
    }

    @Override
    public boolean process(double x, double y, TupleDesc_F64 storage) {
        double angle = this.orientation.compute(x, y);
        double scale = this.regionRadius / this.canonicalRadius;
        this.surf.describe(x, y, angle, scale, true, storage);
        return true;
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.surf.getDescriptionLength());
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }
}

