/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.struct.feature.TupleDesc;

public class TupleDesc_B
implements TupleDesc<TupleDesc_B> {
    public int[] data;
    public int numBits;

    public TupleDesc_B(int numBits) {
        int numInts = numBits / 32;
        if (numBits % 32 != 0) {
            ++numInts;
        }
        this.numBits = numBits;
        this.data = new int[numInts];
    }

    public TupleDesc_B(int numBits, int numInts) {
        this.numBits = numBits;
        this.data = new int[numInts];
    }

    public boolean isBitTrue(int bit) {
        int index = bit / 32;
        return (this.data[index] >> bit % 32 & 1) == 1;
    }

    public void setBit(int bit, boolean value) {
        int index = bit / 32;
        if (value) {
            int n = index;
            this.data[n] = this.data[n] | 1 << bit % 32;
        } else {
            int n = index;
            this.data[n] = this.data[n] & ~(1 << bit % 32);
        }
    }

    @Override
    public void setTo(TupleDesc_B source) {
        if (this.data.length < source.data.length) {
            throw new IllegalArgumentException("Data array is too small to store the source array.");
        }
        this.numBits = source.numBits;
        System.arraycopy(source.data, 0, this.data, 0, source.data.length);
    }

    @Override
    public double getDouble(int index) {
        if (this.isBitTrue(index)) {
            return 1.0;
        }
        return -1.0;
    }

    @Override
    public boolean isEquals(TupleDesc_B tuple) {
        if (this.size() != tuple.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.data[i] == tuple.data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.numBits;
    }

    @Override
    public TupleDesc_B newInstance() {
        return new TupleDesc_B(this.numBits, this.data.length);
    }

    public int[] getData() {
        return this.data;
    }

    public void setData(int[] data) {
        this.data = data;
    }
}

