/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.struct.feature.TupleDesc;
import java.util.Arrays;

public class NccFeature
implements TupleDesc<NccFeature> {
    public double mean;
    public double sigma;
    public double[] data;

    public NccFeature(int numFeatures) {
        this.data = new double[numFeatures];
    }

    protected NccFeature() {
    }

    @Override
    public NccFeature copy() {
        NccFeature ret = new NccFeature(this.data.length);
        ret.setTo(this);
        return ret;
    }

    public double get(int index) {
        return this.data[index];
    }

    @Override
    public void setTo(double ... value) {
        System.arraycopy(value, 0, this.data, 0, this.data.length);
    }

    public void fill(double value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public void setTo(NccFeature src) {
        System.arraycopy(src.data, 0, this.data, 0, this.data.length);
        this.mean = src.mean;
        this.sigma = src.sigma;
    }

    @Override
    public double getDouble(int index) {
        return this.data[index];
    }

    @Override
    public boolean isEquals(NccFeature tuple) {
        if (this.size() != tuple.size()) {
            return false;
        }
        if (this.mean != tuple.mean) {
            return false;
        }
        if (this.sigma != tuple.sigma) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.data[i] == tuple.data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public NccFeature newInstance() {
        return new NccFeature(this.data.length);
    }

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] data) {
        this.data = data;
    }
}

