/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.PackedTupleArray;
import boofcv.struct.feature.TupleDesc_F64;
import org.ddogleg.struct.BigDogArray_F64;
import org.ddogleg.struct.BigDogGrowth;

public class PackedTupleBigArray_F64
implements PackedTupleArray<TupleDesc_F64> {
    public final int dof;
    public final BigDogArray_F64 array;
    public final TupleDesc_F64 temp;
    protected int numElements;

    public PackedTupleBigArray_F64(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_F64(dof);
        this.array = new BigDogArray_F64(dof, dof * 65536, BigDogGrowth.GROW_FIRST);
        this.array.resize(0);
    }

    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    public void reserve(int numTuples) {
        this.array.reserve(numTuples * this.dof);
    }

    public void append(TupleDesc_F64 element) {
        this.array.append((Object)element.data, 0, this.dof);
        ++this.numElements;
    }

    public void set(int index, TupleDesc_F64 element) {
        this.array.setArray((long)index * (long)this.dof, (Object)element.data, 0, this.dof);
    }

    public TupleDesc_F64 getTemp(int index) {
        this.array.getArray(index * this.dof, this.temp.data, 0, this.dof);
        return this.temp;
    }

    public void getCopy(int index, TupleDesc_F64 dst) {
        this.array.getArray(index * this.dof, dst.data, 0, this.dof);
    }

    public void copy(TupleDesc_F64 src, TupleDesc_F64 dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.dof);
    }

    public int size() {
        return this.numElements;
    }

    public Class<TupleDesc_F64> getElementType() {
        return TupleDesc_F64.class;
    }

    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<TupleDesc_F64> op) {
        this.array.processByBlock(idx0 * this.dof, idx1 * this.dof, (array, arrayIdx0, arrayIdx1, offset) -> {
            int pointIndex = idx0 + offset / this.dof;
            for (int i = arrayIdx0; i < arrayIdx1; i += this.dof) {
                System.arraycopy(array, i, this.temp.data, 0, this.dof);
                op.process(pointIndex++, (Object)this.temp);
            }
        });
    }

    public boolean isEquals(PackedArray<TupleDesc_F64> other) {
        return this.array.isEquivalent(((PackedTupleBigArray_F64)other).array, 0.0);
    }

    @Override
    public int getDOF() {
        return this.dof;
    }
}

