/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.alg.filter.convolve.GConvolveImageOps;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.border.BorderType;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;

public class SiftScaleSpace {
    public final Octave[] octaves;
    double sigma0;
    int firstOctave;
    int lastOctave;
    int numScales;
    double levelK;
    Kernel1D_F32 kernelSigma0;
    Kernel1D_F32[] kernelSigmaToK;
    GrayF32 input;
    GrayF32 tempBlur;
    GrayF32 tempImage;
    InterpolatePixelS<GrayF32> interp = FactoryInterpolation.bilinearPixelS(GrayF32.class, (BorderType)BorderType.EXTENDED);

    public SiftScaleSpace(int firstOctave, int lastOctave, int numScales, double sigma0) {
        BoofMiscOps.checkTrue((firstOctave >= -1 ? 1 : 0) != 0);
        if (lastOctave <= firstOctave) {
            throw new IllegalArgumentException("Last octave must be more than the first octave");
        }
        if (numScales < 1) {
            throw new IllegalArgumentException("Number of scales must be >= 1");
        }
        this.firstOctave = firstOctave;
        this.lastOctave = lastOctave;
        this.numScales = numScales;
        this.sigma0 = sigma0;
        this.octaves = new Octave[this.getTotalOctaves()];
        for (int i = 0; i < this.octaves.length; ++i) {
            this.octaves[i] = new Octave(numScales + 3);
        }
        this.tempImage = new GrayF32(1, 1);
        this.tempBlur = new GrayF32(1, 1);
        this.levelK = Math.pow(2.0, 1.0 / (double)numScales);
        Class kernelType = FactoryKernel.getKernelType(GrayF32.class, (int)1);
        this.kernelSigma0 = (Kernel1D_F32)FactoryKernelGaussian.gaussian((Class)kernelType, (double)sigma0, (int)-1);
        this.kernelSigmaToK = new Kernel1D_F32[numScales + 2];
        for (int i = 1; i < numScales + 3; ++i) {
            double before = this.computeSigmaScale(0, i - 1);
            double sigma = before * Math.sqrt(this.levelK - 1.0);
            this.kernelSigmaToK[i - 1] = (Kernel1D_F32)FactoryKernelGaussian.gaussian((Class)kernelType, (double)sigma, (int)-1);
        }
    }

    public double computeSigmaScale(int octave, int scale) {
        return this.sigma0 * Math.pow(2.0, (double)octave + (double)scale / (double)this.numScales);
    }

    public boolean isOctaveTooSmall(int octaveIdx) {
        Octave o = this.octaves[octaveIdx];
        return o.scales[0].width < 10 || o.scales[0].height < 10;
    }

    public void process(GrayF32 input) {
        this.input = input;
        if (this.firstOctave == -1) {
            PyramidOps.scaleImageUp((ImageGray)input, (ImageGray)this.tempImage, (int)(-2 * this.firstOctave), this.interp);
            this.applyGaussian(this.tempImage, this.octaves[0].scales[0], (Kernel1D)this.kernelSigma0);
        } else {
            this.applyGaussian(input, this.octaves[0].scales[0], (Kernel1D)this.kernelSigma0);
            for (int i = 1; i <= this.firstOctave; ++i) {
                this.applyGaussian(this.octaves[0].scales[0], this.tempImage, (Kernel1D)this.kernelSigma0);
                PyramidOps.scaleDown2((ImageGray)this.tempImage, (ImageGray)this.octaves[0].scales[0]);
            }
        }
        for (int octaveIdx = 0; octaveIdx < this.octaves.length; ++octaveIdx) {
            int i;
            Octave o = this.octaves[octaveIdx];
            o.reshapeToFirst();
            for (i = 1; i < o.scales.length; ++i) {
                this.applyGaussian(o.scales[i - 1], o.scales[i], (Kernel1D)this.kernelSigmaToK[i - 1]);
            }
            for (i = 1; i < o.scales.length; ++i) {
                PixelMath.subtract((GrayF32)o.scales[i], (GrayF32)o.scales[i - 1], (GrayF32)o.differenceOfGaussian[i - 1]);
            }
            if (octaveIdx + 1 >= this.octaves.length) continue;
            PyramidOps.scaleDown2((ImageGray)this.octaves[octaveIdx].scales[this.numScales], (ImageGray)this.octaves[octaveIdx + 1].scales[0]);
        }
    }

    void applyGaussian(GrayF32 input, GrayF32 output, Kernel1D kernel) {
        output.reshape(input.width, input.height);
        this.tempBlur.reshape(input.width, input.height);
        GConvolveImageOps.horizontalNormalized((Kernel1D)kernel, (ImageBase)input, (ImageBase)this.tempBlur);
        GConvolveImageOps.verticalNormalized((Kernel1D)kernel, (ImageBase)this.tempBlur, (ImageBase)output);
    }

    public int getNumScaleImages() {
        return this.numScales + 3;
    }

    public int getTotalOctaves() {
        return this.lastOctave - this.firstOctave + 1;
    }

    public double pixelScaleCurrentToInput(int octave) {
        return Math.pow(2.0, octave);
    }

    public int getOriginalWidth() {
        return this.input.width;
    }

    public int getOriginalHeight() {
        return this.input.height;
    }

    public int getNumScales() {
        return this.numScales;
    }

    public static class Octave {
        public final GrayF32[] scales;
        public final GrayF32[] differenceOfGaussian;

        public Octave(int numScales) {
            int i;
            this.scales = new GrayF32[numScales];
            this.differenceOfGaussian = new GrayF32[numScales - 1];
            for (i = 0; i < this.scales.length; ++i) {
                this.scales[i] = new GrayF32(1, 1);
            }
            for (i = 0; i < this.differenceOfGaussian.length; ++i) {
                this.differenceOfGaussian[i] = new GrayF32(1, 1);
            }
        }

        public void reshapeToFirst() {
            int i;
            int width = this.scales[0].width;
            int height = this.scales[0].height;
            for (i = 1; i < this.scales.length; ++i) {
                this.scales[i].reshape(width, height);
            }
            for (i = 0; i < this.differenceOfGaussian.length; ++i) {
                this.differenceOfGaussian[i].reshape(width, height);
            }
        }
    }
}

