/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.alg.feature.associate.AssociateGreedyBase2D;
import boofcv.alg.feature.associate.AssociateImageDistanceFunction;
import georegression.struct.point.Point2D_F64;

public class AssociateGreedyBruteForce2D<D>
extends AssociateGreedyBase2D<D> {
    public AssociateGreedyBruteForce2D(ScoreAssociation<D> scoreAssociation, AssociateImageDistanceFunction distanceFunction) {
        super(scoreAssociation, distanceFunction);
    }

    @Override
    public void associate() {
        this.setupForAssociate(this.descSrc.size, this.descDst.size);
        double ratioTest = this.ratioTest;
        int idx0 = 0;
        int idx1 = this.descSrc.size;
        for (int idxSrc = idx0; idxSrc < idx1; ++idxSrc) {
            double bestScore;
            this.distanceFunction.setSource(idxSrc, (Point2D_F64)this.locationSrc.get(idxSrc));
            Object a = this.descSrc.data[idxSrc];
            double secondBest = bestScore = this.maxFitError;
            int bestIndex = -1;
            int workIdx = idxSrc * this.descDst.size;
            for (int idxDst = 0; idxDst < this.descDst.size; ++idxDst) {
                Object b = this.descDst.data[idxDst];
                double distance = this.distanceFunction.distance(idxDst, (Point2D_F64)this.locationDst.get(idxDst));
                if (distance > this.maxDistanceUnits) {
                    this.scoreMatrix.set(workIdx + idxDst, this.maxFitError);
                    continue;
                }
                double fit = this.score.score(a, b);
                this.scoreMatrix.set(workIdx + idxDst, fit);
                if (!(fit <= bestScore)) continue;
                bestIndex = idxDst;
                secondBest = bestScore;
                bestScore = fit;
            }
            if (ratioTest < 1.0 && bestIndex != -1 && bestScore != 0.0) {
                for (int j = bestIndex + 1; j < this.descDst.size; ++j) {
                    double fit = this.scoreMatrix.get(workIdx + j);
                    if (!(fit < secondBest)) continue;
                    secondBest = fit;
                }
                this.pairs.set(idxSrc, secondBest * ratioTest >= bestScore ? bestIndex : -1);
            } else {
                this.pairs.set(idxSrc, bestIndex);
            }
            this.fitQuality.set(idxSrc, bestScore);
        }
        if (this.backwardsValidation) {
            for (int i = 0; i < this.descSrc.size; ++i) {
                this.forwardsBackwards(i, this.descSrc.size, this.descDst.size);
            }
        }
    }
}

