/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;

public class Surf_DetectDescribe<T extends ImageGray<T>, II extends ImageGray<II>>
implements DetectDescribePoint<T, TupleDesc_F64> {
    protected FastHessianFeatureDetector<II> detector;
    protected OrientationIntegral<II> orientation;
    protected DescribePointSurf<II> describe;
    protected II ii;
    protected DogArray<TupleDesc_F64> features;
    protected List<ScalePoint> foundPoints;
    protected DogArray_F64 featureAngles = new DogArray_F64(10);
    ImageType<T> imageType;

    public Surf_DetectDescribe(FastHessianFeatureDetector<II> detector, OrientationIntegral<II> orientation, DescribePointSurf<II> describe, Class<T> imageType) {
        this.detector = detector;
        this.orientation = orientation;
        this.describe = describe;
        this.imageType = ImageType.single(imageType);
        this.features = new DogArray(describe::createDescription);
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return this.describe.createDescription();
    }

    @Override
    public TupleDesc_F64 getDescription(int index) {
        return (TupleDesc_F64)this.features.get(index);
    }

    @Override
    public ImageType<T> getInputType() {
        return this.imageType;
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }

    @Override
    public void detect(T input) {
        if (this.ii != null) {
            this.ii.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        }
        this.ii = GIntegralImageOps.transform(input, this.ii);
        this.features.reset();
        this.featureAngles.reset();
        this.detector.detect(this.ii);
        this.foundPoints = this.detector.getFoundFeatures();
        this.features.resize(this.foundPoints.size());
        this.featureAngles.resize(this.foundPoints.size());
        this.computeDescriptors();
    }

    @Override
    public int getNumberOfSets() {
        return 2;
    }

    @Override
    public int getSet(int index) {
        return this.foundPoints.get((int)index).white ? 0 : 1;
    }

    protected void computeDescriptors() {
        this.orientation.setImage(this.ii);
        this.describe.setImage(this.ii);
        for (int i = 0; i < this.foundPoints.size(); ++i) {
            ScalePoint p = this.foundPoints.get(i);
            double radius = p.scale * 2.0;
            this.orientation.setObjectRadius(radius);
            double angle = this.orientation.compute(p.pixel.x, p.pixel.y);
            this.describe.describe(p.pixel.x, p.pixel.y, angle, p.scale, true, (TupleDesc_F64)this.features.get(i));
            this.featureAngles.set(i, angle);
        }
    }

    @Override
    public int getNumberOfFeatures() {
        return this.foundPoints.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.foundPoints.get((int)featureIndex).pixel;
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.foundPoints.get((int)featureIndex).scale * 2.0;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.featureAngles.get(featureIndex);
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }
}

