/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.misc.BoofLambdas;
import boofcv.struct.feature.PackedTupleArray;
import boofcv.struct.feature.TupleDesc_U8;
import org.ddogleg.struct.BigDogArray_I8;
import org.ddogleg.struct.BigDogGrowth;

public class PackedTupleBigArray_U8
implements PackedTupleArray<TupleDesc_U8> {
    public final int dof;
    public final BigDogArray_I8 array;
    public final TupleDesc_U8 temp;
    protected int numElements;

    public PackedTupleBigArray_U8(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_U8(dof);
        this.array = new BigDogArray_I8(dof, dof * 65536, BigDogGrowth.GROW_FIRST);
        this.array.resize(0);
    }

    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    public void reserve(int numTuples) {
        this.array.reserve(numTuples * this.dof);
    }

    public void append(TupleDesc_U8 element) {
        this.array.append((Object)element.data, 0, this.dof);
        ++this.numElements;
    }

    public void set(int index, TupleDesc_U8 element) {
        this.array.setArray((long)index * (long)this.dof, (Object)element.data, 0, this.dof);
    }

    public TupleDesc_U8 getTemp(int index) {
        this.array.getArray(index * this.dof, this.temp.data, 0, this.dof);
        return this.temp;
    }

    public void getCopy(int index, TupleDesc_U8 dst) {
        this.array.getArray(index * this.dof, dst.data, 0, this.dof);
    }

    public void copy(TupleDesc_U8 src, TupleDesc_U8 dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.dof);
    }

    public int size() {
        return this.numElements;
    }

    public Class<TupleDesc_U8> getElementType() {
        return TupleDesc_U8.class;
    }

    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<TupleDesc_U8> op) {
        this.array.processByBlock(idx0 * this.dof, idx1 * this.dof, (array, arrayIdx0, arrayIdx1, offset) -> {
            int pointIndex = idx0 + offset / this.dof;
            for (int i = arrayIdx0; i < arrayIdx1; i += this.dof) {
                System.arraycopy(array, i, this.temp.data, 0, this.dof);
                op.process(pointIndex++, (Object)this.temp);
            }
        });
    }

    @Override
    public int getDOF() {
        return this.dof;
    }
}

